/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="wait", defaultValue="true")
    private boolean wait;
    @Parameter(property="amps.properties", required=true, defaultValue="false")
    protected boolean writePropertiesToFile;
    @Parameter(property="testGroup")
    protected String testGroup;
    @Parameter(property="excludeInstances")
    protected String excludeInstances;
    protected final Map<String, String> properties = new HashMap<String, String>();

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getUpdateChecker().check();
        this.getAmpsPluginVersionChecker().checkAmpsVersionInPom(this.getSdkVersion(), this.getMavenContext().getProject());
        this.promptForEmailSubscriptionIfNeeded();
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Run");
        List<ProductExecution> productExecutions = this.getProductExecutions();
        this.startProducts(productExecutions);
    }

    protected void startProducts(List<ProductExecution> productExecutions) throws MojoExecutionException {
        long globalStartTime = System.nanoTime();
        this.setParallelMode(productExecutions);
        ArrayList successMessages = Lists.newArrayList();
        for (ProductExecution productExecution : productExecutions) {
            ProductHandler productHandler = productExecution.getProductHandler();
            Product product = productExecution.getProduct();
            if (product.isInstallPlugin() == null) {
                product.setInstallPlugin(this.shouldInstallPlugin());
            }
            if (this.shouldBuildTestPlugin()) {
                List<ProductArtifact> plugins = product.getBundledArtifacts();
                plugins.addAll(this.testFrameworkPlugins);
            }
            this.getLog().info((CharSequence)"");
            if (org.apache.maven.surefire.shade.org.apache.commons.lang.StringUtils.isNotBlank((String)product.getOutput())) {
                this.getLog().info((CharSequence)String.format("Starting %s... (see log at %s)", product.getInstanceId(), product.getOutput()));
            } else {
                this.getLog().info((CharSequence)String.format("Starting %s...", product.getInstanceId()));
            }
            long startTime = System.nanoTime();
            int actualHttpPort = productHandler.start(product);
            long durationSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
            StartupInformation message = new StartupInformation(product, "started successfully", actualHttpPort, durationSeconds);
            if (!this.parallel) {
                this.getLog().info((CharSequence)message.toString());
            }
            successMessages.add(message);
            if (!this.writePropertiesToFile) continue;
            if (productExecutions.size() == 1) {
                this.properties.put("http.port", String.valueOf(actualHttpPort));
                this.properties.put("context.path", product.getContextPath());
            }
            this.properties.put("http." + product.getInstanceId() + ".port", String.valueOf(actualHttpPort));
            this.properties.put("context." + product.getInstanceId() + ".path", product.getContextPath());
            String baseUrl = MavenGoals.getBaseUrl(product, actualHttpPort);
            this.properties.put("baseurl." + product.getInstanceId(), baseUrl);
        }
        if (this.writePropertiesToFile) {
            this.writePropertiesFile();
        }
        if (this.parallel) {
            this.waitForProducts(productExecutions, true);
        }
        long globalDurationSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - globalStartTime);
        if (successMessages.size() > 1 || this.parallel) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("=== Summary (total time " + globalDurationSeconds + "s):"));
            for (StartupInformation message : successMessages) {
                if (!org.apache.maven.surefire.shade.org.apache.commons.lang.StringUtils.isNotBlank((String)message.getOutput())) continue;
                this.getLog().info((CharSequence)("Log available at: " + message.getOutput()));
            }
            for (StartupInformation message : successMessages) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
        if (this.wait) {
            this.getLog().info((CharSequence)"Type Ctrl-D to shutdown gracefully");
            this.getLog().info((CharSequence)"Type Ctrl-C to exit");
            try {
                while (System.in.read() != -1) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.stopProducts(productExecutions);
        }
    }

    protected List<ProductExecution> getProductExecutions() throws MojoExecutionException {
        List<ProductExecution> productExecutions;
        MavenGoals goals = this.getMavenGoals();
        if (!StringUtils.isBlank((String)this.testGroup)) {
            productExecutions = this.getTestGroupProductExecutions(this.testGroup);
        } else if (!StringUtils.isBlank((String)this.instanceId)) {
            Product ctx = this.getProductContexts().get(this.instanceId);
            if (ctx == null) {
                throw new MojoExecutionException("No product with instance ID '" + this.instanceId + "'");
            }
            ProductHandler product = this.createProductHandler(ctx.getId());
            productExecutions = Collections.singletonList(new ProductExecution(ctx, product));
        } else {
            Product ctx = this.getProductContexts().get(this.getProductId());
            ProductHandler product = this.createProductHandler(ctx.getId());
            productExecutions = Collections.singletonList(new ProductExecution(ctx, product));
        }
        return this.filterExcludedInstances(this.includeStudioDependentProducts(productExecutions, goals));
    }

    private List<ProductExecution> filterExcludedInstances(List<ProductExecution> executions) throws MojoExecutionException {
        if (org.apache.maven.surefire.shade.org.apache.commons.lang.StringUtils.isBlank((String)this.excludeInstances)) {
            return executions;
        }
        boolean inverted = this.excludeInstances.startsWith("*/");
        String instanceIdList = inverted ? this.excludeInstances.substring(2) : this.excludeInstances;
        ArrayList excludedInstanceIds = Lists.newArrayList((Object[])instanceIdList.split(","));
        ArrayList excludedExecutions = Lists.newArrayList();
        for (final String instanceId : excludedInstanceIds) {
            try {
                excludedExecutions.add(Iterables.find(executions, (Predicate)new Predicate<ProductExecution>(){

                    public boolean apply(ProductExecution input) {
                        return input.getProduct().getInstanceId().equals(instanceId);
                    }
                }));
            }
            catch (NoSuchElementException nsee) {
                throw new MojoExecutionException("You specified -Dexclude=" + this.excludeInstances + " but " + instanceId + " is not an existing instance id.");
            }
        }
        if (inverted) {
            return excludedExecutions;
        }
        executions.removeAll(excludedExecutions);
        return executions;
    }

    private boolean shouldInstallPlugin() {
        Artifact artifact = this.getMavenContext().getProject().getArtifact();
        return this.installPlugin && artifact != null && !"pom".equalsIgnoreCase(artifact.getType());
    }

    private void writePropertiesFile() throws MojoExecutionException {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        File ampsProperties = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "amps.properties");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(ampsProperties);
            props.store(out, "");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing " + ampsProperties.getAbsolutePath(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static class StartupInformation {
        int actualHttpPort;
        long durationSeconds;
        Product product;
        String event;

        public StartupInformation(Product product, String event, int actualHttpPort, long durationSeconds) {
            this.actualHttpPort = actualHttpPort;
            this.product = product;
            this.event = event;
            this.durationSeconds = durationSeconds;
        }

        public String toString() {
            String message = String.format("%s %s in %ds", this.product.getInstanceId(), this.event + (Boolean.FALSE.equals(this.product.getSynchronousStartup()) ? " (asynchronously)" : ""), this.durationSeconds);
            if (this.actualHttpPort != 0) {
                message = message + " at http://" + this.product.getServer() + ":" + this.actualHttpPort + (this.product.getContextPath().equals("ROOT") ? "" : this.product.getContextPath());
            }
            return message;
        }

        public String getOutput() {
            return this.product.getOutput();
        }
    }
}

