/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard;

import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.gadgets.dashboard.util.Iterables;
import com.atlassian.plugin.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@Immutable
public final class DashboardState
implements Serializable {
    private static final long serialVersionUID = 4862870053224734927L;
    private final DashboardId id;
    private final String title;
    private final Layout layout;
    private List<? extends Iterable<GadgetState>> columns;
    private final long version;

    private DashboardState(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.layout = builder.layout;
        this.version = builder.version;
        this.columns = this.copy(builder.columns, this.layout.getNumberOfColumns());
    }

    private List<? extends Iterable<GadgetState>> copy(Iterable<? extends Iterable<GadgetState>> columns, int size) {
        LinkedList<ImmutableList> copy = new LinkedList<ImmutableList>();
        if (columns != null) {
            for (Iterable<GadgetState> iterable : columns) {
                copy.add(ImmutableList.copyOf(iterable));
            }
        }
        this.pad(copy, size, Collections.emptyList());
        return Collections.unmodifiableList(copy);
    }

    private <E, T extends E> void pad(Collection<E> list, int toSize, T obj) {
        list.addAll(Collections.nCopies(toSize - list.size(), obj));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.columns = this.copy(this.columns, this.layout != null ? this.layout.getNumberOfColumns() : Layout.AA.getNumberOfColumns());
        if (this.id == null) {
            throw new InvalidObjectException("id cannot be null");
        }
        if (this.title == null) {
            throw new InvalidObjectException("title cannot be null");
        }
        if (this.layout == null) {
            throw new InvalidObjectException("layout cannot be null");
        }
        if (this.columns.size() != this.layout.getNumberOfColumns()) {
            throw new InvalidObjectException("columns size must be " + this.layout.getNumberOfColumns());
        }
    }

    public DashboardId getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Iterable<GadgetState> getGadgetsInColumn(ColumnIndex column) {
        return this.columns.get(column.index());
    }

    public Iterable<? extends Iterable<GadgetState>> getColumns() {
        return this.columns;
    }

    public long getVersion() {
        return this.version;
    }

    private DashboardState add(GadgetState gadgetState, ColumnIndex index, boolean prepend) {
        boolean foundRequestedColumn = false;
        LinkedList<Object> modifiedColumns = new LinkedList<Object>();
        for (ColumnIndex i : this.layout.getColumnRange()) {
            Iterable<GadgetState> column = this.getGadgetsInColumn(i);
            if (i.equals((Object)index)) {
                foundRequestedColumn = true;
                LinkedList<GadgetState> newColumn = new LinkedList<GadgetState>();
                if (prepend) {
                    newColumn.add(gadgetState);
                    this.addExistingGadgetsToColumn(column, newColumn);
                } else {
                    this.addExistingGadgetsToColumn(column, newColumn);
                    newColumn.add(gadgetState);
                }
                modifiedColumns.add(ImmutableList.copyOf(newColumn));
                continue;
            }
            modifiedColumns.add(column);
        }
        if (!foundRequestedColumn) {
            throw new IllegalArgumentException("index is out of this dashboard's columns range");
        }
        return DashboardState.dashboard(this.id).title(this.title).layout(this.layout).columns(modifiedColumns).version(this.version).build();
    }

    private void addExistingGadgetsToColumn(Iterable<GadgetState> column, List<GadgetState> newColumn) {
        for (GadgetState gadget : column) {
            newColumn.add(gadget);
        }
    }

    public DashboardState prependGadgetToColumn(GadgetState gadgetState, ColumnIndex index) {
        return this.add(gadgetState, index, true);
    }

    public DashboardState appendGadgetToColumn(GadgetState gadgetState, ColumnIndex index) {
        return this.add(gadgetState, index, false);
    }

    public boolean equals(Object o) {
        ColumnIndex columnIndex;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DashboardState)) {
            return false;
        }
        DashboardState rhs = (DashboardState)o;
        boolean equals = new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append((Object)this.getTitle(), (Object)rhs.getTitle()).append((Object)this.getLayout(), (Object)rhs.getLayout()).isEquals();
        if (!equals) {
            return false;
        }
        Iterator<ColumnIndex> i$ = this.getLayout().getColumnRange().iterator();
        while (i$.hasNext() && (equals = Iterables.elementsEqual(this.getGadgetsInColumn(columnIndex = i$.next()), rhs.getGadgetsInColumn(columnIndex)))) {
        }
        return equals;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.getId()).append((Object)this.getTitle()).append((Object)this.getLayout());
        for (ColumnIndex columnIndex : this.getLayout().getColumnRange()) {
            builder.append(this.getGadgetsInColumn(columnIndex));
        }
        return builder.toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("title", (Object)this.getTitle()).append("layout", (Object)this.getLayout()).append("columns", this.columns).toString();
    }

    public static Builder dashboard(DashboardState state) {
        return new Builder((DashboardState)Assertions.notNull((String)"state", (Object)state));
    }

    public static TitleBuilder dashboard(DashboardId id) {
        return new TitleBuilder((DashboardId)Assertions.notNull((String)"id", (Object)id));
    }

    public static enum ColumnIndex {
        ZERO(0),
        ONE(1),
        TWO(2);

        private final int index;

        private ColumnIndex(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public boolean hasNext() {
            return this != TWO;
        }

        public ColumnIndex next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No next column index, already at the max");
            }
            return ColumnIndex.from(this.index + 1);
        }

        public static ColumnIndex from(int index) {
            switch (index) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
                case 2: {
                    return TWO;
                }
            }
            throw new IllegalArgumentException("Valid values for Column are 0-2");
        }

        public static Iterable<ColumnIndex> range(final ColumnIndex start, final ColumnIndex end) {
            return new Iterable<ColumnIndex>(){

                @Override
                public Iterator<ColumnIndex> iterator() {
                    return new Iterator<ColumnIndex>(){
                        private ColumnIndex nextIndex;
                        {
                            this.nextIndex = start;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextIndex != null;
                        }

                        @Override
                        public ColumnIndex next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            ColumnIndex currentIndex = this.nextIndex;
                            this.nextIndex = currentIndex.hasNext() && currentIndex != end ? currentIndex.next() : null;
                            return currentIndex;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Cannot remove elements from this iterator");
                        }
                    };
                }
            };
        }
    }

    public static class Builder {
        private DashboardId id;
        private String title;
        private Layout layout = Layout.AA;
        private Iterable<? extends Iterable<GadgetState>> columns = Collections.emptyList();
        private long version = 0L;

        private Builder(DashboardId id, String title) {
            this.id = id;
            this.title = title;
        }

        private Builder(DashboardState state) {
            this.id = state.getId();
            this.title = state.getTitle();
            this.layout = state.getLayout();
            ArrayList<? extends Iterable<GadgetState>> columns = new ArrayList<Iterable<GadgetState>>();
            for (ColumnIndex columnIndex : this.layout.getColumnRange()) {
                columns.add(state.getGadgetsInColumn(columnIndex));
            }
            this.columns = columns;
            this.version = state.getVersion();
        }

        public Builder layout(Layout layout) {
            this.layout = (Layout)((Object)Assertions.notNull((String)"layout", (Object)((Object)layout)));
            return this;
        }

        public Builder title(String title) {
            this.title = (String)Assertions.notNull((String)"title", (Object)title);
            return this;
        }

        public Builder columns(Iterable<? extends Iterable<GadgetState>> columns) {
            this.columns = Iterables.checkContentsNotNull((Iterable)Assertions.notNull((String)"columns", columns));
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public DashboardState build() {
            return new DashboardState(this);
        }
    }

    public static class TitleBuilder {
        private DashboardId id;

        private TitleBuilder(DashboardId id) {
            this.id = id;
        }

        public Builder title(String title) {
            return new Builder(this.id, (String)Assertions.notNull((String)"title", (Object)title));
        }
    }
}

