/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.util.PasswordHelper;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InternalDirectoryUtilsImpl
implements InternalDirectoryUtils {
    private final PasswordHelper passwordHelper;

    public InternalDirectoryUtilsImpl(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }

    @Override
    public void validateDirectoryForEntity(DirectoryEntity entity, Long directoryId) {
        Validate.notNull((Object)entity, (String)"entity cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getDirectoryId(), (String)"directoryId of entity cannot be null", (Object[])new Object[0]);
        Validate.isTrue((entity.getDirectoryId() == directoryId.longValue() ? 1 : 0) != 0, (String)"directoryId does not match the directoryId of the InternalDirectory", (Object[])new Object[0]);
    }

    @Override
    public void validateUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("A username must not be null or empty or blank");
        }
    }

    @Override
    public void validateCredential(PasswordCredential credential, String regex, @Nullable String passwordComplexityMessage) throws InvalidCredentialException {
        Preconditions.checkNotNull((Object)credential);
        if (!credential.isEncryptedCredential()) {
            if (StringUtils.isBlank((CharSequence)credential.getCredential())) {
                throw new InvalidCredentialException("You cannot have an empty password");
            }
            if (!this.passwordHelper.validateRegex(regex, credential)) {
                throw new InvalidCredentialException("The new password does not meet the directory complexity requirements", StringUtils.stripToNull((String)passwordComplexityMessage));
            }
        }
    }

    @Override
    public void validateGroupName(Group group, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            throw new IllegalArgumentException("A group name must not be null or empty or blank");
        }
    }
}

