/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import org.springframework.security.providers.ldap.authenticator.LdapShaPasswordEncoder;

public class LdapSshaPasswordEncoder
extends LdapShaPasswordEncoder
implements LdapPasswordEncoder,
InternalPasswordEncoder {
    private PropertyManager propertyManager;

    public LdapSshaPasswordEncoder() {
        this.setForceLowerCasePrefix(false);
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        String encodedPassword = null;
        if (salt == null) {
            try {
                salt = this.propertyManager.getTokenSeed().getBytes();
                encodedPassword = super.encodePassword(rawPass, salt);
            }
            catch (PropertyManagerException e) {
                throw new PasswordEncoderException(e.getMessage(), e);
            }
        } else {
            encodedPassword = super.encodePassword(rawPass, salt);
        }
        return encodedPassword;
    }

    @Override
    public String getKey() {
        return "ssha";
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }
}

