/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDirectoryCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(RemoteDirectoryCacheRefresher.class);

    public RemoteDirectoryCacheRefresher(RemoteDirectory remoteDirectory) {
        super(remoteDirectory);
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        return false;
    }

    private List<User> findAllRemoteUsers() throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote users");
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        log.info("found [ " + users.size() + " ] remote users in [ " + (System.currentTimeMillis() - start) + "ms ]");
        return users;
    }

    private List<Group> findAllRemoteGroups(GroupType groupType) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote groups");
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).returningAtMost(-1));
        log.info("found [ " + groups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
        return groups;
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<User> ldapUsers = this.findAllRemoteUsers();
        directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
        directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<Group> groups = RemoteDirectoryCacheRefresher.filterOutDuplicateGroups(this.findAllRemoteGroups(GroupType.GROUP));
        directoryCache.addOrUpdateCachedGroups(groups, syncStartDate);
        directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, groups, syncStartDate);
        return groups;
    }
}

