/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.builder;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.AliasQuery;
import com.atlassian.crowd.search.query.entity.ApplicationQuery;
import com.atlassian.crowd.search.query.entity.DirectoryQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.TokenQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.GroupMembersOfGroupQuery;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.crowd.search.query.membership.UserMembershipQuery;
import org.apache.commons.lang3.Validate;

public class QueryBuilder {
    private static final SearchRestriction DEFAULT_RESTRICTION = NullRestrictionImpl.INSTANCE;
    private static final int DEFAULT_START_INDEX = 0;

    public static <T> PartialEntityQuery<T> queryFor(Class<T> returnType, EntityDescriptor entity) {
        Validate.notNull(returnType, (String)"returnType", (Object[])new Object[0]);
        Validate.notNull((Object)entity, (String)"entity", (Object[])new Object[0]);
        return new PartialEntityQuery<T>(returnType, entity);
    }

    public static <T> EntityQuery<T> queryFor(Class<T> returnType, EntityDescriptor entity, SearchRestriction searchRestriction, int startIndex, int maxResults) {
        if (Entity.USER.equals((Object)entity.getEntityType())) {
            return new UserQuery<T>(returnType, searchRestriction, startIndex, maxResults);
        }
        if (Entity.GROUP.equals((Object)entity.getEntityType())) {
            return new GroupQuery<T>(returnType, entity.getGroupType(), searchRestriction, startIndex, maxResults);
        }
        if (Entity.ALIAS.equals((Object)entity.getEntityType())) {
            return new AliasQuery(searchRestriction, startIndex, maxResults);
        }
        if (Entity.APPLICATION.equals((Object)entity.getEntityType())) {
            return new ApplicationQuery(searchRestriction, startIndex, maxResults);
        }
        if (Entity.DIRECTORY.equals((Object)entity.getEntityType())) {
            return new DirectoryQuery(searchRestriction, startIndex, maxResults);
        }
        if (Entity.TOKEN.equals((Object)entity.getEntityType())) {
            return new TokenQuery(searchRestriction, startIndex, maxResults);
        }
        throw new IllegalStateException("Unknown entity type <" + entity + "> is not supported by the builder");
    }

    public static <T> MembershipQuery<T> createMembershipQuery(int maxResults, int startIndex, boolean findMembers, EntityDescriptor entityToReturn, Class<T> returnType, EntityDescriptor entityToMatch, String nameToMatch) {
        if (findMembers && (entityToReturn.equals(EntityDescriptor.group()) || entityToReturn.equals(EntityDescriptor.role()))) {
            return new GroupMembersOfGroupQuery<T>(returnType, findMembers, entityToMatch, nameToMatch, entityToReturn, startIndex, maxResults);
        }
        if (findMembers && entityToReturn.equals(EntityDescriptor.user())) {
            return new UserMembersOfGroupQuery<T>(returnType, findMembers, entityToMatch, nameToMatch, entityToReturn, startIndex, maxResults);
        }
        if (!findMembers && (entityToReturn.equals(EntityDescriptor.group()) || entityToReturn.equals(EntityDescriptor.role()))) {
            return new GroupMembershipQuery<T>(returnType, findMembers, entityToMatch, nameToMatch, entityToReturn, startIndex, maxResults);
        }
        if (!findMembers && entityToReturn.equals(EntityDescriptor.user())) {
            return new UserMembershipQuery<T>(returnType, findMembers, entityToMatch, nameToMatch, entityToReturn, startIndex, maxResults);
        }
        throw new IllegalStateException("What the f**k happened!");
    }

    public static class PartialEntityQueryWithStartIndex<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entity;
        private final SearchRestriction restriction;
        private final int startIndex;

        public PartialEntityQueryWithStartIndex(Class<T> returnType, EntityDescriptor entity, SearchRestriction restriction, int startIndex) {
            this.returnType = returnType;
            this.entity = entity;
            this.startIndex = startIndex;
            this.restriction = restriction;
        }

        public EntityQuery<T> returningAtMost(int maxResults) {
            return QueryBuilder.queryFor(this.returnType, this.entity, this.restriction, this.startIndex, maxResults);
        }
    }

    public static class PartialEntityQueryWithRestriction<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entity;
        private final SearchRestriction restriction;

        public PartialEntityQueryWithRestriction(Class<T> returnType, EntityDescriptor entity, SearchRestriction restriction) {
            this.returnType = returnType;
            this.entity = entity;
            this.restriction = restriction;
        }

        public PartialEntityQueryWithStartIndex<T> startingAt(int index) {
            return new PartialEntityQueryWithStartIndex<T>(this.returnType, this.entity, this.restriction, index);
        }

        public EntityQuery<T> returningAtMost(int maxResults) {
            return QueryBuilder.queryFor(this.returnType, this.entity, this.restriction, 0, maxResults);
        }
    }

    public static class PartialMembershipQueryWithStartIndex<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;
        private final String nameToMatch;
        private final int startIndex;

        public PartialMembershipQueryWithStartIndex(Class<T> returnType, EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers, String nameToMatch, int startIndex) {
            this.returnType = returnType;
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
            this.nameToMatch = nameToMatch;
            this.startIndex = startIndex;
        }

        public MembershipQuery<T> returningAtMost(int maxResults) {
            return QueryBuilder.createMembershipQuery(maxResults, this.startIndex, this.findMembers, this.entityToReturn, this.returnType, this.entityToMatch, this.nameToMatch);
        }
    }

    public static class PartialMembershipQueryWithNameToMatch<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;
        private final String nameToMatch;

        public PartialMembershipQueryWithNameToMatch(Class<T> returnType, EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers, String nameToMatch) {
            this.returnType = returnType;
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
            this.nameToMatch = nameToMatch;
        }

        public PartialMembershipQueryWithStartIndex<T> startingAt(int index) {
            return new PartialMembershipQueryWithStartIndex<T>(this.returnType, this.entityToReturn, this.entityToMatch, this.findMembers, this.nameToMatch, index);
        }

        public MembershipQuery<T> returningAtMost(int maxResults) {
            return QueryBuilder.createMembershipQuery(maxResults, 0, this.findMembers, this.entityToReturn, this.returnType, this.entityToMatch, this.nameToMatch);
        }
    }

    public static class PartialMembershipQueryWithEntityToMatch<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;

        public PartialMembershipQueryWithEntityToMatch(Class<T> returnType, EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers) {
            this.returnType = returnType;
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
        }

        public PartialMembershipQueryWithNameToMatch<T> withName(String name) {
            return new PartialMembershipQueryWithNameToMatch<T>(this.returnType, this.entityToReturn, this.entityToMatch, this.findMembers, name);
        }
    }

    public static class PartialEntityQuery<T> {
        private final Class<T> returnType;
        private final EntityDescriptor entity;

        public PartialEntityQuery(Class<T> returnType, EntityDescriptor entity) {
            this.returnType = returnType;
            this.entity = entity;
        }

        public PartialEntityQueryWithRestriction<T> with(SearchRestriction restriction) {
            return new PartialEntityQueryWithRestriction<T>(this.returnType, this.entity, restriction);
        }

        public PartialEntityQueryWithStartIndex<T> startingAt(int index) {
            return new PartialEntityQueryWithStartIndex<T>(this.returnType, this.entity, DEFAULT_RESTRICTION, index);
        }

        public EntityQuery<T> returningAtMost(int maxResults) {
            return QueryBuilder.queryFor(this.returnType, this.entity, DEFAULT_RESTRICTION, 0, maxResults);
        }

        public PartialMembershipQueryWithEntityToMatch<T> childrenOf(EntityDescriptor entityToMatch) {
            return new PartialMembershipQueryWithEntityToMatch<T>(this.returnType, this.entity, entityToMatch, true);
        }

        public PartialMembershipQueryWithEntityToMatch<T> parentsOf(EntityDescriptor entityToMatch) {
            return new PartialMembershipQueryWithEntityToMatch<T>(this.returnType, this.entity, entityToMatch, false);
        }

        public Object ofType(GroupType groupType) {
            return null;
        }
    }
}

