/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.builder.model.SigningConfig;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.security.KeyStore;

public class DefaultSigningConfig
implements SigningConfig {
    public static final String DEFAULT_PASSWORD = "android";
    public static final String DEFAULT_ALIAS = "AndroidDebugKey";
    protected final String mName;
    private File mStoreFile = null;
    private String mStorePassword = null;
    private String mKeyAlias = null;
    private String mKeyPassword = null;
    private String mStoreType = KeyStore.getDefaultType();
    private boolean mV1SigningEnabled = true;
    private boolean mV2SigningEnabled = true;

    public DefaultSigningConfig(String name) {
        this.mName = name;
    }

    public void initDebug() throws AndroidLocation.AndroidLocationException {
        this.mStoreFile = new File(KeystoreHelper.defaultDebugKeystoreLocation());
        this.mStorePassword = DEFAULT_PASSWORD;
        this.mKeyAlias = DEFAULT_ALIAS;
        this.mKeyPassword = DEFAULT_PASSWORD;
    }

    public String getName() {
        return this.mName;
    }

    public File getStoreFile() {
        return this.mStoreFile;
    }

    public DefaultSigningConfig setStoreFile(File storeFile) {
        this.mStoreFile = storeFile;
        return this;
    }

    public String getStorePassword() {
        return this.mStorePassword;
    }

    public DefaultSigningConfig setStorePassword(String storePassword) {
        this.mStorePassword = storePassword;
        return this;
    }

    public String getKeyAlias() {
        return this.mKeyAlias;
    }

    public DefaultSigningConfig setKeyAlias(String keyAlias) {
        this.mKeyAlias = keyAlias;
        return this;
    }

    public String getKeyPassword() {
        return this.mKeyPassword;
    }

    public DefaultSigningConfig setKeyPassword(String keyPassword) {
        this.mKeyPassword = keyPassword;
        return this;
    }

    public String getStoreType() {
        return this.mStoreType;
    }

    public DefaultSigningConfig setStoreType(String storeType) {
        this.mStoreType = storeType;
        return this;
    }

    public boolean isV1SigningEnabled() {
        return this.mV1SigningEnabled;
    }

    public void setV1SigningEnabled(boolean enabled) {
        this.mV1SigningEnabled = enabled;
    }

    public boolean isV2SigningEnabled() {
        return this.mV2SigningEnabled;
    }

    public void setV2SigningEnabled(boolean enabled) {
        this.mV2SigningEnabled = enabled;
    }

    public boolean isSigningReady() {
        return this.mStoreFile != null && this.mStorePassword != null && this.mKeyAlias != null && this.mKeyPassword != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSigningConfig that = (DefaultSigningConfig)o;
        if (this.mKeyAlias != null ? !this.mKeyAlias.equals(that.mKeyAlias) : that.mKeyAlias != null) {
            return false;
        }
        if (this.mKeyPassword != null ? !this.mKeyPassword.equals(that.mKeyPassword) : that.mKeyPassword != null) {
            return false;
        }
        if (this.mStoreFile != null ? !this.mStoreFile.equals(that.mStoreFile) : that.mStoreFile != null) {
            return false;
        }
        if (this.mStorePassword != null ? !this.mStorePassword.equals(that.mStorePassword) : that.mStorePassword != null) {
            return false;
        }
        return !(this.mStoreType != null ? !this.mStoreType.equals(that.mStoreType) : that.mStoreType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mStoreFile != null ? this.mStoreFile.hashCode() : 0);
        result = 31 * result + (this.mStorePassword != null ? this.mStorePassword.hashCode() : 0);
        result = 31 * result + (this.mKeyAlias != null ? this.mKeyAlias.hashCode() : 0);
        result = 31 * result + (this.mKeyPassword != null ? this.mKeyPassword.hashCode() : 0);
        result = 31 * result + (this.mStoreType != null ? this.mStoreType.hashCode() : 0);
        result = 31 * result + (this.mV1SigningEnabled ? 17 : 0);
        result = 31 * result + (this.mV2SigningEnabled ? 17 : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("storeFile", (Object)this.mStoreFile.getAbsolutePath()).add("storePassword", (Object)this.mStorePassword).add("keyAlias", (Object)this.mKeyAlias).add("keyPassword", (Object)this.mKeyPassword).add("storeType", (Object)this.mStoreType).add("v1SigningEnabled", this.mV1SigningEnabled).add("v2SigningEnabled", this.mV2SigningEnabled).toString();
    }
}

