/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessRecorder;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ProcessRecorderFactory {
    private static final DateTimeFormatter PROFILE_FILE_NAME = DateTimeFormatter.ofPattern("'profile-'YYYY-MM-dd-HH-mm-ss-SSS'.rawproto'", Locale.US);
    private ScheduledExecutorService mScheduledExecutorService = Executors.newScheduledThreadPool(1);
    private ILogger mLogger = null;
    private static final Object LOCK = new Object();
    static ProcessRecorderFactory sINSTANCE = new ProcessRecorderFactory();
    private ProcessRecorder processRecorder = null;
    private Path profileOutputFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                ProcessRecorderFactory.sINSTANCE.processRecorder.finish();
            }
            ProcessRecorderFactory.sINSTANCE.processRecorder = null;
        }
    }

    ProcessRecorderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(File projectPath, String gradleVersion, ILogger logger, File profileOutputDirectory) {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                return;
            }
            sINSTANCE.setLogger(logger);
            sINSTANCE.setProfileOutputFile(profileOutputDirectory.toPath().resolve(PROFILE_FILE_NAME.format(LocalDateTime.now())));
            ProcessRecorder recorder = sINSTANCE.get();
            ProcessRecorderFactory.setGlobalProperties(recorder, projectPath, gradleVersion, logger);
        }
    }

    private static void setGlobalProperties(ProcessRecorder recorder, File projectPath, String gradleVersion, ILogger logger) {
        String anonymizedProjectId;
        recorder.getProperties().setOsName(Strings.nullToEmpty((String)System.getProperty("os.name"))).setOsVersion(Strings.nullToEmpty((String)System.getProperty("os.version"))).setJavaVersion(Strings.nullToEmpty((String)System.getProperty("java.version"))).setJavaVmVersion(Strings.nullToEmpty((String)System.getProperty("java.vm.version"))).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(Strings.nullToEmpty((String)gradleVersion));
        try {
            anonymizedProjectId = Anonymizer.anonymizeUtf8((ILogger)logger, (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            anonymizedProjectId = "*ANONYMIZATION_ERROR*";
        }
        recorder.getProperties().setProjectId(anonymizedProjectId);
    }

    public synchronized void setLogger(ILogger iLogger) {
        this.assertRecorderNotCreated();
        this.mLogger = iLogger;
    }

    public static ProcessRecorderFactory getFactory() {
        return sINSTANCE;
    }

    boolean isInitialized() {
        return this.processRecorder != null;
    }

    private void assertRecorderNotCreated() {
        if (this.isInitialized()) {
            throw new RuntimeException("ProcessRecorder already created.");
        }
    }

    public static void initializeForTests(Path profileOutputFile) {
        sINSTANCE = new ProcessRecorderFactory();
        sINSTANCE.setProfileOutputFile(profileOutputFile);
        ProcessRecorder.resetForTests();
        ProcessRecorder recorder = sINSTANCE.get();
        ProcessRecorderFactory.setGlobalProperties(recorder, new File("fake/path/to/test_project/"), "2.10", (ILogger)new StdLogger(StdLogger.Level.VERBOSE));
    }

    private static void initializeAnalytics(ILogger logger, ScheduledExecutorService eventLoop) {
        AnalyticsSettings settings = AnalyticsSettings.getInstance((ILogger)logger);
        UsageTracker.initialize((AnalyticsSettings)settings, (ScheduledExecutorService)eventLoop);
        UsageTracker tracker = UsageTracker.getInstance();
        tracker.setMaxJournalTime(10L, TimeUnit.MINUTES);
        tracker.setMaxJournalSize(1000);
    }

    private void setProfileOutputFile(Path outputFile) {
        this.profileOutputFile = outputFile;
    }

    synchronized ProcessRecorder get() {
        if (this.processRecorder == null) {
            Preconditions.checkState((this.profileOutputFile != null ? 1 : 0) != 0, (Object)"call setProfileOutputFile() first");
            if (this.mLogger == null) {
                this.mLogger = new StdLogger(StdLogger.Level.INFO);
            }
            ProcessRecorderFactory.initializeAnalytics(this.mLogger, this.mScheduledExecutorService);
            this.processRecorder = new ProcessRecorder(this.profileOutputFile);
        }
        return this.processRecorder;
    }
}

