/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.MemoryStats;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessRecorder {
    private final GradleBuildMemorySample mStartMemoryStats;
    private final NameAnonymizer mNameAnonymizer;
    private final GradleBuildProfile.Builder mBuild;
    private final LoadingCache<String, Project> mProjects;
    private final Path mBenchmarkProfileOutputFile;
    private static final AtomicLong lastRecordId = new AtomicLong(1L);

    static long allocateRecordId() {
        return lastRecordId.incrementAndGet();
    }

    @VisibleForTesting
    static void resetForTests() {
        lastRecordId.set(1L);
    }

    static ProcessRecorder get() {
        return ProcessRecorderFactory.sINSTANCE.get();
    }

    ProcessRecorder(Path benchmarkProfileOutputFile) {
        this.mBenchmarkProfileOutputFile = benchmarkProfileOutputFile;
        this.mNameAnonymizer = new NameAnonymizer();
        this.mBuild = GradleBuildProfile.newBuilder();
        this.mStartMemoryStats = this.createAndRecordMemorySample();
        this.mProjects = CacheBuilder.newBuilder().build((CacheLoader)new ProjectCacheLoader(this.mNameAnonymizer));
    }

    void writeRecord(String project, String variant, GradleBuildProfileSpan.Builder executionRecord) {
        executionRecord.setProject(this.mNameAnonymizer.anonymizeProjectPath(project));
        executionRecord.setVariant(this.mNameAnonymizer.anonymizeVariant(project, variant));
        this.mBuild.addSpan(executionRecord.build());
    }

    void finish() throws InterruptedException {
        GradleBuildMemorySample memoryStats = this.createAndRecordMemorySample();
        this.mBuild.setBuildTime(memoryStats.getTimestamp() - this.mStartMemoryStats.getTimestamp());
        this.mBuild.setGcCount(memoryStats.getGcCount() - this.mStartMemoryStats.getGcCount());
        this.mBuild.setGcTime(memoryStats.getGcTimeMs() - this.mStartMemoryStats.getGcTimeMs());
        for (Project project : this.mProjects.asMap().values()) {
            for (GradleBuildVariant.Builder variant : project.variants.values()) {
                project.properties.addVariant(variant);
            }
            if (project.properties == null) continue;
            this.mBuild.addProject(project.properties);
        }
        try {
            Files.createDirectories(this.mBenchmarkProfileOutputFile.getParent(), new FileAttribute[0]);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.mBenchmarkProfileOutputFile, StandardOpenOption.CREATE_NEW));){
                this.mBuild.build().writeTo((OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE).setGradleBuildProfile(this.mBuild.build()).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setJvmDetails(CommonMetricsData.getJvmDetails()));
    }

    public static GradleBuildProfile.Builder getGlobalProperties() {
        return ProcessRecorder.get().getProperties();
    }

    GradleBuildProfile.Builder getProperties() {
        return this.mBuild;
    }

    public static GradleBuildProject.Builder getProject(String projectPath) {
        return ((Project)ProcessRecorder.get().mProjects.getUnchecked((Object)projectPath)).properties;
    }

    public static GradleBuildVariant.Builder addVariant(String projectPath, String variantName) {
        GradleBuildVariant.Builder properties = GradleBuildVariant.newBuilder();
        ProcessRecorder.get().addVariant(projectPath, variantName, properties);
        return properties;
    }

    private void addVariant(String projectPath, String variantName, GradleBuildVariant.Builder properties) {
        Project project = (Project)this.mProjects.getUnchecked((Object)projectPath);
        properties.setId(this.mNameAnonymizer.anonymizeVariant(projectPath, variantName));
        project.variants.put(variantName, properties);
    }

    private GradleBuildMemorySample createAndRecordMemorySample() {
        GradleBuildMemorySample stats = MemoryStats.getCurrentProperties();
        if (stats != null) {
            this.mBuild.addMemorySample(stats);
        }
        return stats;
    }

    public static void recordMemorySample() {
        ProcessRecorder.get().createAndRecordMemorySample();
    }

    private static class Project {
        final Map<String, GradleBuildVariant.Builder> variants = Maps.newConcurrentMap();
        final GradleBuildProject.Builder properties = GradleBuildProject.newBuilder();

        Project(long id) {
            this.properties.setId(id);
        }
    }

    private static class ProjectCacheLoader
    extends CacheLoader<String, Project> {
        private final NameAnonymizer mNameAnonymizer;

        ProjectCacheLoader(NameAnonymizer nameAnonymizer) {
            this.mNameAnonymizer = nameAnonymizer;
        }

        public Project load(String name) throws Exception {
            return new Project(this.mNameAnonymizer.anonymizeProjectPath(name));
        }
    }
}

