/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ReadWriteProcessLock {
    private static final ConcurrentMap<File, ReadWriteProcessLock> sReadWriteProcessLockMap = new ConcurrentHashMap<File, ReadWriteProcessLock>();
    private final ReadLock mReadLock = new ReadLock();
    private final WriteLock mWriteLock = new WriteLock();
    private final ReadWriteLock mSingleProcessLock = new ReentrantReadWriteLock();
    private final ProcessSynchronizer mProcessSynchronizer;
    private int mNumOfReadingActions = 0;

    private ReadWriteProcessLock(File lockFile) {
        this.mProcessSynchronizer = new ProcessSynchronizer(lockFile);
    }

    public static ReadWriteProcessLock getInstance(File lockFile) throws IOException {
        return sReadWriteProcessLockMap.computeIfAbsent(lockFile.getCanonicalFile(), canonicalLockFile -> new ReadWriteProcessLock((File)canonicalLockFile));
    }

    public ReadLock readLock() {
        return this.mReadLock;
    }

    public WriteLock writeLock() {
        return this.mWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireReadLock() throws IOException {
        this.mSingleProcessLock.readLock().lock();
        try {
            ReadWriteProcessLock readWriteProcessLock = this;
            synchronized (readWriteProcessLock) {
                if (this.mNumOfReadingActions == 0) {
                    this.mProcessSynchronizer.acquireReadLock();
                }
                ++this.mNumOfReadingActions;
            }
        }
        catch (Throwable throwable) {
            this.mSingleProcessLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReadLock() throws IOException {
        try {
            ReadWriteProcessLock readWriteProcessLock = this;
            synchronized (readWriteProcessLock) {
                --this.mNumOfReadingActions;
                if (this.mNumOfReadingActions == 0) {
                    this.mProcessSynchronizer.releaseLock();
                }
            }
        }
        finally {
            this.mSingleProcessLock.readLock().unlock();
        }
    }

    private void acquireWriteLock() throws IOException {
        this.mSingleProcessLock.writeLock().lock();
        try {
            this.mProcessSynchronizer.acquireWriteLock();
        }
        catch (Throwable throwable) {
            this.mSingleProcessLock.writeLock().unlock();
            throw throwable;
        }
    }

    private void releaseWriteLock() throws IOException {
        try {
            this.mProcessSynchronizer.releaseLock();
        }
        finally {
            this.mSingleProcessLock.writeLock().unlock();
        }
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireWriteLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseWriteLock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireReadLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseReadLock();
        }
    }

    public static interface Lock {
        public void lock() throws IOException;

        public void unlock() throws IOException;
    }

    private static final class ProcessSynchronizer {
        private final File mLockFile;
        private FileChannel mFileChannel;
        private FileLock mFileLock;

        public ProcessSynchronizer(File lockFile) {
            this.mLockFile = lockFile;
        }

        public void acquireReadLock() throws IOException {
            this.mFileChannel = new RandomAccessFile(this.mLockFile, "rw").getChannel();
            this.mFileLock = this.mFileChannel.lock(0L, Long.MAX_VALUE, true);
        }

        public void acquireWriteLock() throws IOException {
            this.mFileChannel = new RandomAccessFile(this.mLockFile, "rw").getChannel();
            this.mFileLock = this.mFileChannel.lock(0L, Long.MAX_VALUE, false);
        }

        public void releaseLock() throws IOException {
            Preconditions.checkNotNull((Object)this.mFileChannel);
            Preconditions.checkNotNull((Object)this.mFileLock);
            this.mFileLock.release();
            this.mFileChannel.close();
        }
    }
}

