/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.ZipFieldInvariant;
import com.android.builder.internal.packaging.zip.utils.LittleEndianUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;

abstract class ZipField {
    private final String mName;
    protected final int mOffset;
    private final int mSize;
    private final Long mExpected;
    private Set<ZipFieldInvariant> mInvariants;

    ZipField(int offset, int size, String name, ZipFieldInvariant ... invariants) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset >= 0");
        Preconditions.checkArgument((size == 2 || size == 4 ? 1 : 0) != 0, (Object)"size != 2 && size != 4");
        this.mName = name;
        this.mOffset = offset;
        this.mSize = size;
        this.mExpected = null;
        this.mInvariants = Sets.newHashSet((Object[])invariants);
    }

    ZipField(int offset, int size, long expected, String name) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset >= 0");
        Preconditions.checkArgument((size == 2 || size == 4 ? 1 : 0) != 0, (Object)"size != 2 && size != 4");
        this.mName = name;
        this.mOffset = offset;
        this.mSize = size;
        this.mExpected = expected;
        this.mInvariants = Sets.newHashSet();
    }

    private void checkVerifiesInvariants(long value) throws IOException {
        for (ZipFieldInvariant invariant : this.mInvariants) {
            if (invariant.isValid(value)) continue;
            throw new IOException("Value " + value + " of field " + this.mName + " is invalid (fails '" + invariant.getName() + "').");
        }
    }

    void skip(ByteBuffer bytes) throws IOException {
        if (bytes.remaining() < this.mSize) {
            throw new IOException("Cannot skip field " + this.mName + " because only " + bytes.remaining() + " remain in the buffer.");
        }
        bytes.position(bytes.position() + this.mSize);
    }

    long read(ByteBuffer bytes) throws IOException {
        if (bytes.remaining() < this.mSize) {
            throw new IOException("Cannot skip field " + this.mName + " because only " + bytes.remaining() + " remain in the buffer.");
        }
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        long r = this.mSize == 2 ? (long)LittleEndianUtils.readUnsigned2Le(bytes) : LittleEndianUtils.readUnsigned4Le(bytes);
        this.checkVerifiesInvariants(r);
        return r;
    }

    void verify(ByteBuffer bytes) throws IOException {
        Preconditions.checkState((this.mExpected != null ? 1 : 0) != 0, (Object)"mExpected == null");
        this.verify(bytes, this.mExpected);
    }

    void verify(ByteBuffer bytes, long expected) throws IOException {
        this.checkVerifiesInvariants(expected);
        long r = this.read(bytes);
        if (r != expected) {
            throw new IOException("Incorrect value for field '" + this.mName + "': value is " + r + " but " + expected + " expected.");
        }
    }

    void write(ByteBuffer output, long value) throws IOException {
        this.checkVerifiesInvariants(value);
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value (%s) < 0", (Object[])new Object[]{value});
        if (this.mSize == 2) {
            Preconditions.checkArgument((value <= 65535L ? 1 : 0) != 0, (String)"value (%s) > 0x0000ffff", (Object[])new Object[]{value});
            LittleEndianUtils.writeUnsigned2Le(output, Ints.checkedCast((long)value));
        } else {
            Verify.verify((this.mSize == 4 ? 1 : 0) != 0);
            Preconditions.checkArgument((value <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"value (%s) > 0x00000000ffffffffL", (Object[])new Object[]{value});
            LittleEndianUtils.writeUnsigned4Le(output, value);
        }
    }

    void write(ByteBuffer output) throws IOException {
        Preconditions.checkState((this.mExpected != null ? 1 : 0) != 0, (Object)"mExpected == null");
        this.write(output, this.mExpected);
    }

    int endOffset() {
        return this.mOffset + this.mSize;
    }

    static class F4
    extends ZipField {
        F4(int offset, String name, ZipFieldInvariant ... invariants) {
            super(offset, 4, name, invariants);
        }

        F4(int offset, long expected, String name) {
            super(offset, 4, expected, name);
        }
    }

    static class F2
    extends ZipField {
        F2(int offset, String name, ZipFieldInvariant ... invariants) {
            super(offset, 2, name, invariants);
        }

        F2(int offset, long expected, String name) {
            super(offset, 2, expected, name);
        }
    }
}

