/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.utils.LittleEndianUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExtraField {
    static final int ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = 55605;
    private final byte[] mRawData;
    private ImmutableList<Segment> mSegments;

    public ExtraField(byte[] rawData) {
        this.mRawData = rawData;
        this.mSegments = null;
    }

    public ExtraField() {
        this.mRawData = null;
        this.mSegments = ImmutableList.of();
    }

    public ExtraField(ImmutableList<Segment> segments) {
        this.mRawData = null;
        this.mSegments = segments;
    }

    public ImmutableList<Segment> getSegments() throws IOException {
        if (this.mSegments == null) {
            this.parseSegments();
        }
        Preconditions.checkNotNull(this.mSegments);
        return this.mSegments;
    }

    public Segment getSingleSegment(int headerId) throws IOException {
        List found = this.getSegments().stream().filter(s -> s.getHeaderId() == headerId).collect(Collectors.toList());
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() == 1) {
            return (Segment)found.get(0);
        }
        throw new IOException(found.size() + " segments with header ID " + headerId + "found");
    }

    private void parseSegments() throws IOException {
        Preconditions.checkNotNull((Object)this.mRawData);
        Preconditions.checkState((this.mSegments == null ? 1 : 0) != 0);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ByteBuffer buffer = ByteBuffer.wrap(this.mRawData);
        while (buffer.remaining() > 0) {
            int headerId = LittleEndianUtils.readUnsigned2Le(buffer);
            int dataSize = LittleEndianUtils.readUnsigned2Le(buffer);
            if (dataSize < 0) {
                throw new IOException("Invalid data size for extra field segment with header ID " + headerId + ": " + dataSize);
            }
            byte[] data = new byte[dataSize];
            buffer.get(data);
            SegmentFactory factory = ExtraField.identifySegmentFactory(headerId);
            Segment seg = factory.make(headerId, data);
            segments.add(seg);
        }
        this.mSegments = ImmutableList.copyOf(segments);
    }

    public int size() {
        if (this.mRawData != null) {
            return this.mRawData.length;
        }
        Preconditions.checkNotNull(this.mSegments);
        int sz = 0;
        for (Segment s : this.mSegments) {
            sz += s.size();
        }
        return sz;
    }

    public void write(ByteBuffer out) throws IOException {
        if (this.mRawData != null) {
            out.put(this.mRawData);
        } else {
            Preconditions.checkNotNull(this.mSegments);
            for (Segment s : this.mSegments) {
                s.write(out);
            }
        }
    }

    private static SegmentFactory identifySegmentFactory(int headerId) {
        if (headerId == 55605) {
            return AlignmentSegment::new;
        }
        return RawDataSegment::new;
    }

    public static class AlignmentSegment
    implements Segment {
        private int mAlignment;
        private int mPadding;

        public AlignmentSegment(int alignment, int totalSize) {
            Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
            Preconditions.checkArgument((totalSize >= 6 ? 1 : 0) != 0, (Object)"totalSize < 6");
            this.mAlignment = alignment;
            this.mPadding = totalSize - 6;
        }

        public AlignmentSegment(int headerId, byte[] data) throws IOException {
            Preconditions.checkArgument((headerId == 55605 ? 1 : 0) != 0);
            ByteBuffer dataBuffer = ByteBuffer.wrap(data);
            this.mAlignment = LittleEndianUtils.readUnsigned2Le(dataBuffer);
            if (this.mAlignment <= 0) {
                throw new IOException("Invalid alignment in alignment field: " + this.mAlignment);
            }
            this.mPadding = data.length - 2;
        }

        @Override
        public void write(ByteBuffer out) throws IOException {
            LittleEndianUtils.writeUnsigned2Le(out, 55605);
            LittleEndianUtils.writeUnsigned2Le(out, this.mPadding + 2);
            LittleEndianUtils.writeUnsigned2Le(out, this.mAlignment);
            out.put(new byte[this.mPadding]);
        }

        @Override
        public int size() {
            return this.mPadding + 6;
        }

        @Override
        public int getHeaderId() {
            return 55605;
        }
    }

    public static class RawDataSegment
    implements Segment {
        private final int mHeaderId;
        private final byte[] mData;

        RawDataSegment(int headerId, byte[] data) {
            this.mHeaderId = headerId;
            this.mData = data;
        }

        @Override
        public int getHeaderId() {
            return this.mHeaderId;
        }

        @Override
        public void write(ByteBuffer out) throws IOException {
            LittleEndianUtils.writeUnsigned2Le(out, this.mHeaderId);
            LittleEndianUtils.writeUnsigned2Le(out, this.mData.length);
            out.put(this.mData);
        }

        @Override
        public int size() {
            return 4 + this.mData.length;
        }
    }

    @FunctionalInterface
    static interface SegmentFactory {
        public Segment make(int var1, byte[] var2) throws IOException;
    }

    public static interface Segment {
        public int getHeaderId();

        public int size();

        public void write(ByteBuffer var1) throws IOException;
    }
}

