/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.GPFlags;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class EncodeUtils {
    private EncodeUtils() {
    }

    public static String decode(ByteBuffer bytes, int length, GPFlags flags) throws IOException {
        if (bytes.remaining() < length) {
            throw new IOException("Only " + bytes.remaining() + " bytes exist in the buffer, but length is " + length + ".");
        }
        Charset charset = EncodeUtils.flagsCharset(flags);
        byte[] stringBytes = new byte[length];
        bytes.get(stringBytes);
        return charset.decode(ByteBuffer.wrap(stringBytes)).toString();
    }

    public static String decode(byte[] data, GPFlags flags) {
        Charset charset = EncodeUtils.flagsCharset(flags);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }

    public static byte[] encode(String name, GPFlags flags) {
        Charset charset = EncodeUtils.flagsCharset(flags);
        ByteBuffer bytes = charset.encode(name);
        byte[] result = new byte[bytes.remaining()];
        bytes.get(result);
        return result;
    }

    private static Charset flagsCharset(GPFlags flags) {
        if (flags.isUtf8FileName()) {
            return Charsets.UTF_8;
        }
        return Charsets.US_ASCII;
    }

    public static boolean canAsciiEncode(String text) {
        return Charsets.US_ASCII.newEncoder().canEncode(text);
    }
}

