/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CentralDirectoryHeaderCompressInfo;
import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.EncodeUtils;
import com.android.builder.internal.packaging.zip.ExtraField;
import com.android.builder.internal.packaging.zip.GPFlags;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZipField;
import com.android.builder.internal.packaging.zip.ZipFieldInvariant;
import com.android.builder.internal.packaging.zip.ZipFieldInvariantNonNegative;
import com.android.builder.internal.utils.CachedSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

class CentralDirectory {
    private static final ZipField.F4 F_SIGNATURE = new ZipField.F4(0, 33639248L, "Signature");
    private static final ZipField.F2 F_MADE_BY = new ZipField.F2(F_SIGNATURE.endOffset(), "Made by", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_VERSION_EXTRACT = new ZipField.F2(F_MADE_BY.endOffset(), "Version to extract", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_GP_BIT = new ZipField.F2(F_VERSION_EXTRACT.endOffset(), "GP bit", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_METHOD = new ZipField.F2(F_GP_BIT.endOffset(), "Method", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_TIME = new ZipField.F2(F_METHOD.endOffset(), "Last modification time", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_DATE = new ZipField.F2(F_LAST_MOD_TIME.endOffset(), "Last modification date", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_CRC32 = new ZipField.F4(F_LAST_MOD_DATE.endOffset(), "CRC32", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_COMPRESSED_SIZE = new ZipField.F4(F_CRC32.endOffset(), "Compressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F4 F_UNCOMPRESSED_SIZE = new ZipField.F4(F_COMPRESSED_SIZE.endOffset(), "Uncompressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_FILE_NAME_LENGTH = new ZipField.F2(F_UNCOMPRESSED_SIZE.endOffset(), "File name length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_EXTRA_FIELD_LENGTH = new ZipField.F2(F_FILE_NAME_LENGTH.endOffset(), "Extra field length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_COMMENT_LENGTH = new ZipField.F2(F_EXTRA_FIELD_LENGTH.endOffset(), "Comment length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_DISK_NUMBER_START = new ZipField.F2(F_COMMENT_LENGTH.endOffset(), 0L, "Disk start");
    private static final ZipField.F2 F_INTERNAL_ATTRIBUTES = new ZipField.F2(F_DISK_NUMBER_START.endOffset(), "Int attributes", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_EXTERNAL_ATTRIBUTES = new ZipField.F4(F_INTERNAL_ATTRIBUTES.endOffset(), "Ext attributes", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_OFFSET = new ZipField.F4(F_EXTERNAL_ATTRIBUTES.endOffset(), "Offset", new ZipFieldInvariantNonNegative());
    private static final int MAX_VERSION_TO_EXTRACT = 20;
    private static final int ASCII_BIT = 1;
    private final Map<String, StoredEntry> mEntries = Maps.newHashMap();
    private final ZFile mFile;
    private final CachedSupplier<byte[]> mBytesSupplier;

    CentralDirectory(ZFile file) {
        this.mFile = file;
        this.mBytesSupplier = new CachedSupplier<byte[]>(this::computeByteRepresentation);
    }

    static CentralDirectory makeFromData(ByteBuffer bytes, int count, ZFile file) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count < 0");
        CentralDirectory directory = new CentralDirectory(file);
        for (int i = 0; i < count; ++i) {
            try {
                directory.readEntry(bytes, file);
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed to read directory entry index " + i + " (total directory bytes read: " + bytes.position() + ").", e);
            }
        }
        return directory;
    }

    static CentralDirectory makeFromEntries(Set<StoredEntry> entries, ZFile file) {
        CentralDirectory directory = new CentralDirectory(file);
        for (StoredEntry entry : entries) {
            CentralDirectoryHeader cdr = entry.getCentralDirectoryHeader();
            Preconditions.checkArgument((!directory.mEntries.containsKey(cdr.getName()) ? 1 : 0) != 0, (Object)"Duplicate filename");
            directory.mEntries.put(cdr.getName(), entry);
        }
        return directory;
    }

    private void readEntry(ByteBuffer bytes, ZFile file) throws IOException {
        StoredEntry entry;
        long lastModDate;
        long lastModTime;
        F_SIGNATURE.verify(bytes);
        long madeBy = F_MADE_BY.read(bytes);
        long versionNeededToExtract = F_VERSION_EXTRACT.read(bytes);
        if (versionNeededToExtract > 20L) {
            throw new IOException("Unknown version needed to extract in zip directory entry: " + versionNeededToExtract + ".");
        }
        long gpBit = F_GP_BIT.read(bytes);
        GPFlags flags = GPFlags.from(gpBit);
        long methodCode = F_METHOD.read(bytes);
        CompressionMethod method = CompressionMethod.fromCode(methodCode);
        if (method == null) {
            throw new IOException("Unknown method in zip directory entry: " + methodCode + ".");
        }
        if (this.mFile.areTimestampsIgnored()) {
            lastModTime = 0L;
            lastModDate = 0L;
            F_LAST_MOD_TIME.skip(bytes);
            F_LAST_MOD_DATE.skip(bytes);
        } else {
            lastModTime = F_LAST_MOD_TIME.read(bytes);
            lastModDate = F_LAST_MOD_DATE.read(bytes);
        }
        long crc32 = F_CRC32.read(bytes);
        long compressedSize = F_COMPRESSED_SIZE.read(bytes);
        long uncompressedSize = F_UNCOMPRESSED_SIZE.read(bytes);
        int fileNameLength = Ints.checkedCast((long)F_FILE_NAME_LENGTH.read(bytes));
        int extraFieldLength = Ints.checkedCast((long)F_EXTRA_FIELD_LENGTH.read(bytes));
        int fileCommentLength = Ints.checkedCast((long)F_COMMENT_LENGTH.read(bytes));
        F_DISK_NUMBER_START.verify(bytes);
        long internalAttributes = F_INTERNAL_ATTRIBUTES.read(bytes);
        if ((internalAttributes & 0xFFFFFFFFFFFFFFFEL) != 0L) {
            throw new IOException("Invalid internal attributes: " + internalAttributes + ".");
        }
        long externalAttributes = F_EXTERNAL_ATTRIBUTES.read(bytes);
        long entryOffset = F_OFFSET.read(bytes);
        long remainingSize = fileNameLength + extraFieldLength + fileCommentLength;
        if (bytes.remaining() < fileNameLength + extraFieldLength + fileCommentLength) {
            throw new IOException("Directory entry should have " + remainingSize + " bytes remaining (name = " + fileNameLength + ", extra = " + extraFieldLength + ", comment = " + fileCommentLength + "), but it has " + bytes.remaining() + ".");
        }
        String fileName = EncodeUtils.decode(bytes, fileNameLength, flags);
        byte[] extraField = new byte[extraFieldLength];
        bytes.get(extraField);
        byte[] fileCommentField = new byte[fileCommentLength];
        bytes.get(fileCommentField);
        ListenableFuture compressInfo = Futures.immediateFuture((Object)new CentralDirectoryHeaderCompressInfo(method, compressedSize, versionNeededToExtract));
        CentralDirectoryHeader centralDirectoryHeader = new CentralDirectoryHeader(fileName, uncompressedSize, (Future<CentralDirectoryHeaderCompressInfo>)compressInfo, flags, file);
        centralDirectoryHeader.setMadeBy(madeBy);
        centralDirectoryHeader.setLastModTime(lastModTime);
        centralDirectoryHeader.setLastModDate(lastModDate);
        centralDirectoryHeader.setCrc32(crc32);
        centralDirectoryHeader.setInternalAttributes(internalAttributes);
        centralDirectoryHeader.setExternalAttributes(externalAttributes);
        centralDirectoryHeader.setOffset(entryOffset);
        centralDirectoryHeader.setExtraFieldNoNotify(new ExtraField(extraField));
        centralDirectoryHeader.setComment(fileCommentField);
        try {
            entry = new StoredEntry(centralDirectoryHeader, this.mFile, null);
        }
        catch (IOException e) {
            throw new IOException("Failed to read stored entry '" + fileName + "'.", e);
        }
        if (this.mEntries.containsKey(fileName)) {
            throw new IOException("File file contains duplicate file '" + fileName + "'.");
        }
        this.mEntries.put(fileName, entry);
    }

    Map<String, StoredEntry> getEntries() {
        return ImmutableMap.copyOf(this.mEntries);
    }

    byte[] toBytes() throws IOException {
        return this.mBytesSupplier.get();
    }

    private byte[] computeByteRepresentation() {
        ArrayList sorted = Lists.newArrayList(this.mEntries.values());
        Collections.sort(sorted, StoredEntry.COMPARE_BY_NAME);
        CentralDirectoryHeader[] cdhs = new CentralDirectoryHeader[this.mEntries.size()];
        CentralDirectoryHeaderCompressInfo[] compressInfos = new CentralDirectoryHeaderCompressInfo[this.mEntries.size()];
        byte[][] encodedFileNames = new byte[this.mEntries.size()][];
        byte[][] extraFields = new byte[this.mEntries.size()][];
        byte[][] comments = new byte[this.mEntries.size()][];
        try {
            int idx = 0;
            int total = 0;
            for (StoredEntry entry : sorted) {
                cdhs[idx] = entry.getCentralDirectoryHeader();
                compressInfos[idx] = cdhs[idx].getCompressionInfoWithWait();
                encodedFileNames[idx] = cdhs[idx].getEncodedFileName();
                extraFields[idx] = new byte[cdhs[idx].getExtraField().size()];
                cdhs[idx].getExtraField().write(ByteBuffer.wrap(extraFields[idx]));
                comments[idx] = cdhs[idx].getComment();
                total += F_OFFSET.endOffset() + encodedFileNames[idx].length + extraFields[idx].length + comments[idx].length;
                ++idx;
            }
            ByteBuffer out = ByteBuffer.allocate(total);
            for (idx = 0; idx < this.mEntries.size(); ++idx) {
                F_SIGNATURE.write(out);
                F_MADE_BY.write(out, cdhs[idx].getMadeBy());
                F_VERSION_EXTRACT.write(out, compressInfos[idx].getVersionExtract());
                F_GP_BIT.write(out, cdhs[idx].getGpBit().getValue());
                F_METHOD.write(out, compressInfos[idx].getMethod().methodCode);
                if (this.mFile.areTimestampsIgnored()) {
                    F_LAST_MOD_TIME.write(out, 0L);
                    F_LAST_MOD_DATE.write(out, 0L);
                } else {
                    F_LAST_MOD_TIME.write(out, cdhs[idx].getLastModTime());
                    F_LAST_MOD_DATE.write(out, cdhs[idx].getLastModDate());
                }
                F_CRC32.write(out, cdhs[idx].getCrc32());
                F_COMPRESSED_SIZE.write(out, compressInfos[idx].getCompressedSize());
                F_UNCOMPRESSED_SIZE.write(out, cdhs[idx].getUncompressedSize());
                F_FILE_NAME_LENGTH.write(out, cdhs[idx].getEncodedFileName().length);
                F_EXTRA_FIELD_LENGTH.write(out, cdhs[idx].getExtraField().size());
                F_COMMENT_LENGTH.write(out, cdhs[idx].getComment().length);
                F_DISK_NUMBER_START.write(out);
                F_INTERNAL_ATTRIBUTES.write(out, cdhs[idx].getInternalAttributes());
                F_EXTERNAL_ATTRIBUTES.write(out, cdhs[idx].getExternalAttributes());
                F_OFFSET.write(out, cdhs[idx].getOffset());
                out.put(encodedFileNames[idx]);
                out.put(extraFields[idx]);
                out.put(comments[idx]);
            }
            return out.array();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

