/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.sign;

import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZFileExtension;
import com.android.builder.internal.utils.CachedSupplier;
import com.android.builder.internal.utils.IOExceptionRunnable;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestGenerationExtension {
    public static final String META_INF_DIR = "META-INF";
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private final String mBuiltBy;
    private final String mCreatedBy;
    private ZFile mZFile;
    private final Manifest mManifest;
    private CachedSupplier<byte[]> mManifestBytes;
    private boolean mDirty;
    private ZFileExtension mExtension;

    public ManifestGenerationExtension(String builtBy, String createdBy) {
        this.mBuiltBy = builtBy;
        this.mCreatedBy = createdBy;
        this.mManifest = new Manifest();
        this.mDirty = false;
        this.mManifestBytes = new CachedSupplier<byte[]>(() -> {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            try {
                this.mManifest.write(outBytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return outBytes.toByteArray();
        });
    }

    private void markDirty() {
        this.mDirty = true;
        this.mManifestBytes.reset();
    }

    public void register(ZFile zFile) throws IOException {
        Preconditions.checkState((this.mExtension == null ? 1 : 0) != 0, (Object)"register() has already been invoked.");
        this.mZFile = zFile;
        this.rebuildManifest();
        this.mExtension = new ZFileExtension(){

            @Override
            public IOExceptionRunnable beforeUpdate() {
                return () -> ManifestGenerationExtension.this.updateManifest();
            }
        };
        this.mZFile.addZFileExtension(this.mExtension);
    }

    private void rebuildManifest() throws IOException {
        Attributes mainAttributes;
        String currentVersion;
        Verify.verifyNotNull((Object)this.mZFile, (String)"mZFile == null", (Object[])new Object[0]);
        StoredEntry manifestEntry = this.mZFile.get(MANIFEST_NAME);
        if (manifestEntry != null) {
            this.mManifest.clear();
            byte[] manifestBytes = manifestEntry.read();
            this.mManifest.read(new ByteArrayInputStream(manifestBytes));
            this.mManifestBytes.precomputed(manifestBytes);
        }
        if ((currentVersion = (mainAttributes = this.mManifest.getMainAttributes()).getValue("Manifest-Version")) == null) {
            this.setMainAttribute("Manifest-Version", "1.0");
        } else if (!currentVersion.equals("1.0")) {
            throw new IOException("Unsupported manifest version: " + currentVersion + ".");
        }
        this.setMainAttribute("Built-By", this.mBuiltBy);
        this.setMainAttribute("Created-By", this.mCreatedBy);
    }

    private void setMainAttribute(String attribute, String value) {
        Attributes mainAttributes = this.mManifest.getMainAttributes();
        String current = mainAttributes.getValue(attribute);
        if (!value.equals(current)) {
            mainAttributes.putValue(attribute, value);
            this.markDirty();
        }
    }

    private void updateManifest() throws IOException {
        Verify.verifyNotNull((Object)this.mZFile, (String)"mZFile == null", (Object[])new Object[0]);
        if (!this.mDirty) {
            return;
        }
        this.mZFile.add(MANIFEST_NAME, new ByteArrayInputStream(this.mManifestBytes.get()));
        this.mDirty = false;
    }

    public ZFile zFile() {
        Preconditions.checkNotNull((Object)this.mZFile, (Object)"mZFile == null");
        return this.mZFile;
    }

    public StoredEntry manifestEntry() {
        Preconditions.checkNotNull((Object)this.mZFile, (Object)"mZFile == null");
        return this.mZFile.get(MANIFEST_NAME);
    }

    public String getAttribute(String entryName, String attr) {
        Attributes attrs = this.mManifest.getAttributes(entryName);
        if (attrs == null) {
            return null;
        }
        return attrs.getValue(attr);
    }

    public void setAttribute(String entryName, String attr, String value) {
        String current;
        Attributes attrs = this.mManifest.getAttributes(entryName);
        if (attrs == null) {
            attrs = new Attributes();
            this.markDirty();
            this.mManifest.getEntries().put(entryName, attrs);
        }
        if (!value.equals(current = attrs.getValue(attr))) {
            attrs.putValue(attr, value);
            this.markDirty();
        }
    }

    public byte[] getManifestBytes() throws IOException {
        return this.mManifestBytes.get();
    }

    public Map<String, Attributes> allEntries() {
        return Maps.newHashMap(this.mManifest.getEntries());
    }

    public void removeEntry(String name) {
        if (this.mManifest.getEntries().remove(name) != null) {
            this.markDirty();
        }
    }
}

