/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.ApkCreator;
import com.android.builder.packaging.ApkCreatorFactory;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.ZipAbortException;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.builder.signing.SignedJarApkCreatorFactory;
import com.android.ide.common.res2.FileStatus;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@Deprecated
public final class OldPackager
implements Closeable {
    private ApkCreator mApkCreator;
    private final ILogger mLogger;
    private final DuplicateZipFilter mNoDuplicateFilter = new DuplicateZipFilter();
    private final NoJavaClassZipFilter mNoJavaClassZipFilter = new NoJavaClassZipFilter(this.mNoDuplicateFilter);
    private final HashMap<String, File> mAddedFiles = new HashMap();

    public OldPackager(ApkCreatorFactory.CreationData creationData, String resLocation, ILogger logger) throws PackagerException, IOException {
        OldPackager.checkOutputFile(creationData.getApkPath());
        try (Closer closer = Closer.create();){
            OldPackager.checkOutputFile(creationData.getApkPath());
            File resFile = null;
            if (resLocation != null) {
                resFile = new File(resLocation);
                OldPackager.checkInputFile(resFile);
            }
            this.mLogger = logger;
            SignedJarApkCreatorFactory factory = new SignedJarApkCreatorFactory();
            this.mApkCreator = factory.make(creationData);
            this.mLogger.verbose("Packaging %s", new Object[]{creationData.getApkPath().getName()});
            if (resFile != null) {
                this.addZipFile(resFile);
            }
        }
    }

    public void addDexFiles(Set<File> dexFolders) throws PackagerException, IOException {
        block3: {
            block2: {
                Preconditions.checkNotNull((Object)this.mApkCreator, (Object)"mApkCreator == null");
                if (dexFolders.size() != 1) break block2;
                File[] dexFiles = ((File)Iterables.getOnlyElement(dexFolders)).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return name.endsWith(".dex");
                    }
                });
                if (dexFiles == null) break block3;
                for (File dexFile : dexFiles) {
                    this.addFile(dexFile, dexFile.getName());
                }
                break block3;
            }
            int dexIndex = 1;
            for (File folderEntry : dexFolders) {
                dexIndex = this.addContentOfDexFolder(folderEntry, dexIndex);
            }
        }
    }

    private int addContentOfDexFolder(File dexFolder, int dexIndex) throws PackagerException, IOException {
        File[] dexFiles = dexFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".dex");
            }
        });
        if (dexFiles != null) {
            for (File dexFile : dexFiles) {
                this.addFile(dexFile, dexIndex == 1 ? "classes.dex" : String.format("classes%d.dex", dexIndex));
                ++dexIndex;
            }
        }
        return dexIndex;
    }

    public void addFile(File file, String archivePath) throws PackagerException, IOException {
        Preconditions.checkState((this.mApkCreator != null ? 1 : 0) != 0, (Object)"mApkCreator == null");
        this.doAddFile(file, archivePath);
    }

    void addZipFile(File zipFile) throws PackagerException, IOException {
        Preconditions.checkState((this.mApkCreator != null ? 1 : 0) != 0, (Object)"mApkCreator == null");
        this.mLogger.verbose("%s:", new Object[]{zipFile});
        this.mNoDuplicateFilter.reset(zipFile);
        try {
            this.mApkCreator.writeZip(zipFile, null, input -> {
                try {
                    return !this.mNoDuplicateFilter.checkEntry((String)input);
                }
                catch (ZipAbortException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ZipAbortException) {
                throw (ZipAbortException)e.getCause();
            }
            throw e;
        }
    }

    public void updateResource(RelativeFile file, FileStatus modificationType) throws PackagerException {
        if (modificationType != FileStatus.NEW && modificationType != FileStatus.CHANGED) {
            throw new UnsupportedOperationException("Cannot remove a file from archive.");
        }
        this.doAddFile(file.getFile(), file.getOsIndependentRelativePath());
    }

    public void updateResourceArchive(File file, FileStatus modificationType, Predicate<String> isIgnored) throws PackagerException {
        Preconditions.checkNotNull((Object)this.mApkCreator, (Object)"mApkCreator == null");
        if (modificationType == FileStatus.NEW || modificationType == FileStatus.CHANGED) {
            try (Closer closer = Closer.create();){
                Predicate<String> newIsIgnored = input -> {
                    try {
                        if (!this.mNoJavaClassZipFilter.checkEntry((String)input)) {
                            return true;
                        }
                    }
                    catch (ZipAbortException e) {
                        throw new RuntimeException(e);
                    }
                    return isIgnored.test((String)input);
                };
                this.mApkCreator.writeZip(file, null, newIsIgnored);
            }
            catch (IOException e) {
                throw new PackagerException(e);
            }
        }
    }

    private void doAddFile(File file, String archivePath) throws PackagerException {
        Preconditions.checkNotNull((Object)this.mApkCreator, (Object)"mApkCreator == null");
        this.mAddedFiles.put(archivePath, file);
        try {
            this.mApkCreator.writeFile(file, archivePath);
        }
        catch (IOException e) {
            throw new PackagerException(e);
        }
    }

    private File checkFileForDuplicate(String archivePath) {
        return this.mAddedFiles.get(archivePath);
    }

    private static void checkOutputFile(File file) throws PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new PackagerException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new PackagerException("Failed to create %s", file);
                }
                if (!file.delete()) {
                    throw new PackagerException("Failed to delete newly created %s", file);
                }
            }
            catch (IOException e) {
                throw new PackagerException("Failed to create '%1$ss': %2$s", file, e.getMessage());
            }
        }
    }

    private static void checkInputFile(File file) throws FileNotFoundException, PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new PackagerException("Cannot read %s", file);
            }
        } else {
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
    }

    public static String getLocalVersion() {
        Class<IncrementalPackager> clazz = IncrementalPackager.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        try {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            URLConnection jarConnection = new URL(manifestPath).openConnection();
            jarConnection.setUseCaches(false);
            InputStream jarInputStream = jarConnection.getInputStream();
            Attributes attr = new Manifest(jarInputStream).getMainAttributes();
            jarInputStream.close();
            return attr.getValue("Builder-Version");
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.mApkCreator == null) {
            return;
        }
        ApkCreator builder = this.mApkCreator;
        this.mApkCreator = null;
        builder.close();
    }

    private static final class NoJavaClassZipFilter
    implements ZipEntryFilter {
        private final ZipEntryFilter parentFilter;

        private NoJavaClassZipFilter(ZipEntryFilter parentFilter) {
            this.parentFilter = parentFilter;
        }

        @Override
        public boolean checkEntry(String archivePath) throws ZipAbortException {
            return this.parentFilter.checkEntry(archivePath) && !archivePath.endsWith(".class");
        }
    }

    private final class DuplicateZipFilter
    implements ZipEntryFilter {
        private File mInputFile;

        private DuplicateZipFilter() {
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
        }

        @Override
        public boolean checkEntry(String archivePath) throws ZipAbortException {
            OldPackager.this.mLogger.verbose("=> %s", new Object[]{archivePath});
            File duplicate = OldPackager.this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                File potentialDuplicate = new File(this.mInputFile, archivePath);
                if (!duplicate.getAbsolutePath().equals(potentialDuplicate.getAbsolutePath())) {
                    throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
                }
                return false;
            }
            OldPackager.this.mAddedFiles.put(archivePath, this.mInputFile);
            return true;
        }
    }
}

