/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.AbstractBundleDependency;
import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.SkippableLibrary;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class LibraryDependency
extends AbstractBundleDependency
implements AndroidLibrary,
SkippableLibrary {
    private final boolean mIsProvided;
    private final File mJarsRootFolder;
    private final int hashCode;
    private final boolean mIsSubModule;

    public static LibraryDependency createLocalTestedAarLibrary(File bundle, File bundleFolder, String name, String projectPath, String projectVariant) {
        return new LibraryDependency(bundle, bundleFolder, (List<LibraryDependency>)ImmutableList.of(), (Collection<JarDependency>)ImmutableList.of(), name, projectPath, projectVariant, null, new MavenCoordinatesImpl("__tested_library__", bundle.getPath(), "unspecified"), bundleFolder, false, true);
    }

    public static LibraryDependency createStagedAarLibrary(File bundle, File stagedFolder, List<LibraryDependency> androidDependencies, Collection<JarDependency> jarDependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isProvided) {
        return new LibraryDependency(bundle, stagedFolder, androidDependencies, jarDependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates, stagedFolder, isProvided, true);
    }

    public static LibraryDependency createExplodedAarLibrary(File bundle, File explodedBundle, List<LibraryDependency> androidDependencies, Collection<JarDependency> jarDependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isProvided) {
        return new LibraryDependency(bundle, explodedBundle, androidDependencies, jarDependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates, new File(explodedBundle, "jars"), isProvided, false);
    }

    private LibraryDependency(File bundle, File explodedBundle, List<LibraryDependency> androidDependencies, Collection<JarDependency> jarDependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, File jarsRootFolder, boolean isProvided, boolean isSubModule) {
        super(bundle, explodedBundle, androidDependencies, jarDependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates);
        this.mJarsRootFolder = jarsRootFolder;
        this.mIsProvided = isProvided;
        this.mIsSubModule = isSubModule;
        this.hashCode = this.computeHashCode();
    }

    public boolean isSubModule() {
        return this.mIsSubModule;
    }

    public boolean isProvided() {
        return this.mIsProvided;
    }

    public List<File> getLocalJars() {
        ArrayList localJars = Lists.newArrayList();
        File[] jarList = new File(this.getJarsRootFolder(), "libs").listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    public File getJarFile() {
        return new File(this.getJarsRootFolder(), "classes.jar");
    }

    public File getJniFolder() {
        return new File(this.getFolder(), "jni");
    }

    public File getAidlFolder() {
        return new File(this.getFolder(), "aidl");
    }

    public File getRenderscriptFolder() {
        return new File(this.getFolder(), "rs");
    }

    public File getProguardRules() {
        return new File(this.getFolder(), "proguard.txt");
    }

    public File getLintJar() {
        return new File(this.getJarsRootFolder(), "lint.jar");
    }

    public File getExternalAnnotations() {
        return new File(this.getFolder(), "annotations.zip");
    }

    public File getPublicResources() {
        return new File(this.getFolder(), "public.txt");
    }

    public File getSymbolFile() {
        return new File(this.getFolder(), "R.txt");
    }

    protected File getJarsRootFolder() {
        return this.mJarsRootFolder;
    }

    public boolean isSkipped() {
        throw new IllegalAccessError("Call isSkipped on DependenciesMutableData");
    }

    @Deprecated
    public boolean isOptional() {
        return this.isProvided();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return this.mIsProvided == that.mIsProvided && this.mIsSubModule == that.mIsSubModule && Objects.equals(this.mJarsRootFolder, that.mJarsRootFolder);
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(super.hashCode(), this.mIsProvided, this.mIsSubModule, this.mJarsRootFolder);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("mIsProvided", this.mIsProvided).add("mIsSubModule", this.mIsSubModule).add("mJarsRootFolder", (Object)this.mJarsRootFolder).toString();
    }
}

