/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.DependenciesMutableData;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DependencyContainerImpl
implements DependencyContainer {
    private final ImmutableList<AndroidLibrary> mLibraryDependencies;
    private final ImmutableList<AndroidAtom> mAtomDependencies;
    private final ImmutableList<JavaLibrary> mJavaDependencies;
    private final ImmutableList<JavaLibrary> mLocalJars;
    private final AndroidAtom mBaseAtom;
    private final DependenciesMutableData dependenciesMutableData;

    public DependencyContainerImpl(DependenciesMutableData mutableDependencyContainer, List<? extends AndroidLibrary> aars, List<? extends AndroidAtom> atoms, Collection<? extends JavaLibrary> jars, Collection<? extends JavaLibrary> localJars) {
        this.dependenciesMutableData = mutableDependencyContainer;
        this.mLibraryDependencies = ImmutableList.copyOf(aars);
        this.mAtomDependencies = ImmutableList.copyOf(atoms);
        this.mJavaDependencies = ImmutableList.copyOf(jars);
        this.mLocalJars = ImmutableList.copyOf(localJars);
        if (!this.mAtomDependencies.isEmpty()) {
            Object depAtoms = this.mAtomDependencies;
            List subDepAtoms = ((AndroidAtom)depAtoms.get(0)).getAtomDependencies();
            while (!subDepAtoms.isEmpty()) {
                depAtoms = subDepAtoms;
                subDepAtoms = ((AndroidAtom)depAtoms.get(0)).getAtomDependencies();
            }
            assert (depAtoms.size() == 1);
            this.mBaseAtom = (AndroidAtom)depAtoms.get(0);
        } else {
            this.mBaseAtom = null;
        }
    }

    public static DependencyContainer getEmpty() {
        return new DependencyContainerImpl(DependenciesMutableData.EMPTY, (List<? extends AndroidLibrary>)ImmutableList.of(), (List<? extends AndroidAtom>)ImmutableList.of(), (Collection<? extends JavaLibrary>)ImmutableList.of(), (Collection<? extends JavaLibrary>)ImmutableList.of());
    }

    @Override
    public ImmutableList<AndroidLibrary> getAndroidDependencies() {
        return this.mLibraryDependencies;
    }

    @Override
    public ImmutableList<AndroidAtom> getAtomDependencies() {
        return this.mAtomDependencies;
    }

    @Override
    public ImmutableList<JavaLibrary> getJarDependencies() {
        return this.mJavaDependencies;
    }

    @Override
    public ImmutableList<JavaLibrary> getLocalDependencies() {
        return this.mLocalJars;
    }

    @Override
    public AndroidAtom getBaseAtom() {
        return this.mBaseAtom;
    }

    @Override
    public DependencyContainer filterSkippedLibraries() {
        ArrayList libraryDependencies = Lists.newArrayListWithExpectedSize((int)this.mLibraryDependencies.size());
        ArrayList javaDependencies = Lists.newArrayListWithExpectedSize((int)this.mJavaDependencies.size());
        for (AndroidLibrary lib : this.mLibraryDependencies) {
            if (this.dependenciesMutableData.isSkipped((Library)lib)) continue;
            libraryDependencies.add(lib);
        }
        for (AndroidLibrary lib : this.mJavaDependencies) {
            if (this.dependenciesMutableData.isSkipped((Library)lib)) continue;
            javaDependencies.add(lib);
        }
        return new DependencyContainerImpl(this.dependenciesMutableData, libraryDependencies, (List<? extends AndroidAtom>)this.mAtomDependencies, javaDependencies, (Collection<? extends JavaLibrary>)this.mLocalJars);
    }

    @Override
    public DependencyContainer flatten(AndroidLibrary testedLibrary, DependencyContainer testedDependencyContainer) {
        LinkedHashSet<AndroidLibrary> flatAndroidLibs = new LinkedHashSet<AndroidLibrary>();
        LinkedHashSet<AndroidAtom> flatAndroidAtoms = new LinkedHashSet<AndroidAtom>();
        LinkedHashSet<JavaLibrary> flatJavaLibs = new LinkedHashSet<JavaLibrary>();
        DependencyContainerImpl.computeFlatAtomList(this.mAtomDependencies, flatAndroidAtoms, flatAndroidLibs, flatJavaLibs);
        DependencyContainerImpl.computeFlatLibraryList(this.mLibraryDependencies, flatAndroidLibs, flatJavaLibs);
        if (testedLibrary != null) {
            DependencyContainerImpl.computeFlatLibraryList(testedLibrary, flatAndroidLibs, flatJavaLibs);
        }
        DependencyContainerImpl.computeFlatJarList(this.mJavaDependencies, flatJavaLibs);
        Object localJars = this.mLocalJars;
        if (testedDependencyContainer != null && testedLibrary != null) {
            ImmutableList<JavaLibrary> testedLocalJars = testedDependencyContainer.getLocalDependencies();
            localJars = Lists.newArrayListWithExpectedSize((int)this.mLocalJars.size());
            for (JavaLibrary javaLibrary : this.mLocalJars) {
                if (testedLocalJars.contains(javaLibrary)) continue;
                localJars.add((JavaLibrary)javaLibrary);
            }
        }
        return new DependencyContainerImpl(this.dependenciesMutableData, Lists.reverse(new ArrayList<AndroidLibrary>(flatAndroidLibs)), Lists.reverse(new ArrayList<AndroidAtom>(flatAndroidAtoms)), (Collection<? extends JavaLibrary>)flatJavaLibs, (Collection<? extends JavaLibrary>)localJars);
    }

    @Override
    public DependenciesMutableData getDependenciesMutableData() {
        return this.dependenciesMutableData;
    }

    private static void computeFlatAtomList(List<? extends AndroidAtom> androidAtoms, Set<AndroidAtom> outFlatAndroidAtoms, Set<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        for (int i = androidAtoms.size() - 1; i >= 0; --i) {
            DependencyContainerImpl.computeFlatAtomList(androidAtoms.get(i), outFlatAndroidAtoms, outFlatAndroidLibs, outFlatJavaLibs);
        }
    }

    private static void computeFlatLibraryList(List<? extends AndroidLibrary> androidLibs, Set<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        for (int i = androidLibs.size() - 1; i >= 0; --i) {
            DependencyContainerImpl.computeFlatLibraryList(androidLibs.get(i), outFlatAndroidLibs, outFlatJavaLibs);
        }
    }

    private static void computeFlatAtomList(AndroidAtom androidAtom, Set<AndroidAtom> outFlatAndroidAtoms, Set<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        DependencyContainerImpl.computeFlatAtomList(androidAtom.getAtomDependencies(), outFlatAndroidAtoms, outFlatAndroidLibs, outFlatJavaLibs);
        DependencyContainerImpl.computeFlatLibraryList(androidAtom.getLibraryDependencies(), outFlatAndroidLibs, outFlatJavaLibs);
        DependencyContainerImpl.computeFlatJarList(androidAtom.getJavaDependencies(), outFlatJavaLibs);
        if (!outFlatAndroidAtoms.contains(androidAtom)) {
            outFlatAndroidAtoms.add(androidAtom);
        }
    }

    private static void computeFlatLibraryList(AndroidLibrary androidLibrary, Set<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        DependencyContainerImpl.computeFlatLibraryList(androidLibrary.getLibraryDependencies(), outFlatAndroidLibs, outFlatJavaLibs);
        DependencyContainerImpl.computeFlatJarList(androidLibrary.getJavaDependencies(), outFlatJavaLibs);
        if (!outFlatAndroidLibs.contains(androidLibrary)) {
            outFlatAndroidLibs.add(androidLibrary);
        }
    }

    private static void computeFlatJarList(Collection<? extends JavaLibrary> javaLibs, Set<JavaLibrary> outFlatJavaLibs) {
        for (JavaLibrary javaLibrary : javaLibs) {
            outFlatJavaLibs.add(javaLibrary);
            DependencyContainerImpl.computeFlatJarList(javaLibrary.getDependencies(), outFlatJavaLibs);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mLibraryDependencies", this.mLibraryDependencies).add("mAtomDependencies", this.mAtomDependencies).add("mJavaDependencies", this.mJavaDependencies).add("mLocalJars", this.mLocalJars).toString();
    }
}

