/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.DependencyMutableData;
import com.android.builder.model.Library;
import java.util.HashMap;
import java.util.Map;

public interface DependenciesMutableData {
    public static final DependenciesMutableData EMPTY = new DependenciesMutableData(){

        @Override
        public void skip(Library library) {
            throw new RuntimeException(String.format("cannot set skipped attribute on a library with another scope than Package : %1$s", library));
        }

        @Override
        public boolean isSkipped(Library library) {
            return false;
        }
    };

    public static DependenciesMutableData newInstance() {
        return new DependenciesMutableData(){
            Map<Library, DependencyMutableData> mutableDependencyData = new HashMap<Library, DependencyMutableData>();

            private synchronized DependencyMutableData getFor(Library library) {
                DependencyMutableData dependencyMutableData = this.mutableDependencyData.get(library);
                if (dependencyMutableData == null) {
                    dependencyMutableData = new DependencyMutableData();
                    this.mutableDependencyData.put(library, dependencyMutableData);
                }
                return dependencyMutableData;
            }

            @Override
            public boolean isSkipped(Library library) {
                DependencyMutableData dependencyMutableData = this.mutableDependencyData.get(library);
                return dependencyMutableData != null && dependencyMutableData.isSkipped();
            }

            @Override
            public void skip(Library library) {
                this.getFor(library).skip();
            }
        };
    }

    public void skip(Library var1);

    public boolean isSkipped(Library var1);
}

