/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.AbstractBundleDependency;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.MavenCoordinates;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class AtomDependency
extends AbstractBundleDependency
implements AndroidAtom {
    private final List<AtomDependency> mAtomDependencies;
    private final String mAtomName;

    public AtomDependency(File bundle, File explodedBundle, List<LibraryDependency> androidDependencies, List<AtomDependency> atomDependencies, Collection<JarDependency> jarDependencies, String atomName, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates) {
        super(bundle, explodedBundle, androidDependencies, jarDependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates);
        this.mAtomName = atomName;
        this.mAtomDependencies = ImmutableList.copyOf(atomDependencies);
    }

    public String getAtomName() {
        return this.mAtomName;
    }

    public List<? extends AndroidAtom> getAtomDependencies() {
        return this.mAtomDependencies;
    }

    public boolean isSkipped() {
        return false;
    }

    public boolean isProvided() {
        return false;
    }

    public File getJarFile() {
        return new File(this.getFolder(), "classes.jar");
    }

    public File getDexFolder() {
        return new File(this.getFolder(), "dex");
    }

    public File getAtomMetadataFile() {
        return FileUtils.join((File)this.getFolder(), (String[])new String[]{"metadata", "atom-metadata"});
    }

    public File getLibFolder() {
        return new File(this.getFolder(), "libs");
    }

    public File getJavaResFolder() {
        return new File(this.getFolder(), "resources");
    }

    public File getResourcePackage() {
        return new File(this.getFolder(), "resources.ap_");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtomDependency that = (AtomDependency)o;
        return Objects.equal(this.mAtomDependencies, that.mAtomDependencies) && Objects.equal((Object)this.mAtomName, (Object)that.mAtomName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mAtomDependencies, this.mAtomName});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mAtomDependencies", this.mAtomDependencies).add("mAtomName", (Object)this.mAtomName).add("super", (Object)super.toString()).toString();
    }
}

