/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidBundle;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;

public abstract class AbstractBundleDependency
implements AndroidBundle {
    private final File mBundle;
    private final File mBundleFolder;
    private final List<LibraryDependency> mLibraryDependencies;
    private final Collection<JarDependency> mJarDependencies;
    private final String mName;
    private final String mProjectPath;
    private final String mProjectVariant;
    private final MavenCoordinates mRequestedCoordinates;
    private final MavenCoordinates mResolvedCoordinates;
    private final File mManifestFile;

    public AbstractBundleDependency(File bundle, File bundleFolder, List<LibraryDependency> libraryDependencies, Collection<JarDependency> jarDependencies, String name, String projectVariant, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates) {
        this.mBundle = bundle;
        this.mBundleFolder = bundleFolder;
        this.mLibraryDependencies = ImmutableList.copyOf(libraryDependencies);
        this.mJarDependencies = ImmutableList.copyOf(jarDependencies);
        this.mName = name;
        this.mProjectVariant = projectVariant;
        this.mProjectPath = projectPath;
        this.mRequestedCoordinates = requestedCoordinates;
        this.mResolvedCoordinates = resolvedCoordinates;
        this.mManifestFile = new File(this.mBundleFolder, "AndroidManifest.xml");
    }

    public String getProject() {
        return this.mProjectPath;
    }

    public String getName() {
        return this.mName;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return this.mRequestedCoordinates;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.mResolvedCoordinates;
    }

    public String getProjectVariant() {
        return this.mProjectVariant;
    }

    public File getBundle() {
        return this.mBundle;
    }

    public File getFolder() {
        return this.mBundleFolder;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.mLibraryDependencies;
    }

    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.mJarDependencies;
    }

    public File getManifest() {
        return this.mManifestFile;
    }

    public File getResFolder() {
        return new File(this.getFolder(), "res");
    }

    public File getAssetsFolder() {
        return new File(this.getFolder(), "assets");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBundleDependency that = (AbstractBundleDependency)o;
        return Objects.equal((Object)this.mBundle, (Object)that.mBundle) && Objects.equal((Object)this.mBundleFolder, (Object)that.mBundleFolder) && Objects.equal(this.mLibraryDependencies, that.mLibraryDependencies) && Objects.equal(this.mJarDependencies, that.mJarDependencies) && Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mProjectPath, (Object)that.mProjectPath) && Objects.equal((Object)this.mProjectVariant, (Object)that.mProjectVariant) && Objects.equal((Object)this.mRequestedCoordinates, (Object)that.mRequestedCoordinates) && Objects.equal((Object)this.mResolvedCoordinates, (Object)that.mResolvedCoordinates);
    }

    public int hashCode() {
        return HashCodeUtils.hashCode(this.mBundle, this.mBundleFolder, this.mLibraryDependencies, this.mJarDependencies, this.mName, this.mProjectPath, this.mProjectVariant, this.mRequestedCoordinates, this.mResolvedCoordinates);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mBundle", (Object)this.mBundle).add("mBundleFolder", (Object)this.mBundleFolder).add("mLibraryDependencies", this.mLibraryDependencies).add("mJarDependencies", this.mJarDependencies).add("mName", (Object)this.mName).add("mProjectPath", (Object)this.mProjectPath).add("mProjectVariant", (Object)this.mProjectVariant).add("mRequestedCoordinates", (Object)this.mRequestedCoordinates).add("mResolvedCoordinates", (Object)this.mResolvedCoordinates).toString();
    }
}

