/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.BuildToolsServiceLoader;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.JackProcessBuilder;
import com.android.builder.core.JackProcessOptions;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.JsonEncodedGradleMessageParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.JackProvider;
import com.android.jack.api.v01.ChainedException;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.DebugInfoLevel;
import com.android.jack.api.v01.MultiDexKind;
import com.android.jack.api.v01.ReporterKind;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.jack.api.v04.Api04Config;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01Config;
import com.android.jill.api.v01.Api01TranslationTask;
import com.android.jill.api.v01.TranslationException;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;

public class JackToolchain {
    private BuildToolInfo buildToolInfo;
    private ILogger logger;
    private ErrorReporter errorReporter;

    public JackToolchain(BuildToolInfo buildToolInfo, ILogger logger, ErrorReporter errorReporter) {
        this.buildToolInfo = buildToolInfo;
        this.logger = logger;
        this.errorReporter = errorReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(JackProcessOptions options, JavaProcessExecutor javaProcessExecutor, boolean isInProcess) throws ToolchainException, ProcessException, ClassNotFoundException, IOException {
        if (options.getDexOutputDirectory() != null) {
            FileUtils.mkdirs((File)options.getDexOutputDirectory());
        }
        if (options.getOutputFile() != null) {
            FileUtils.mkdirs((File)options.getOutputFile().getParentFile());
        }
        if (options.getCoverageMetadataFile() != null) {
            try {
                FileUtils.mkdirs((File)options.getCoverageMetadataFile().getParentFile());
            }
            catch (RuntimeException ignored) {
                this.logger.warning("Cannot create %1$s directory.", new Object[]{options.getCoverageMetadataFile().getParent()});
            }
        }
        if (options.getIncrementalDir() != null) {
            try {
                FileUtils.mkdirs((File)options.getIncrementalDir());
            }
            catch (RuntimeException ignored) {
                this.logger.warning("Cannot create %1$s directory jack incremental support disabled", new Object[]{options.getIncrementalDir()});
                options.setIncrementalDir(null);
            }
        }
        if (options.getAdditionalParameters().keySet().contains("jack.dex.optimize")) {
            this.logger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        ParsingProcessOutputHandler parser = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new JsonEncodedGradleMessageParser(), Message.Kind.ERROR, this.logger), new MessageReceiver[]{this.errorReporter});
        if (!isInProcess) {
            this.convertUsingCli(options, (ProcessOutputHandler)parser, javaProcessExecutor);
        } else {
            ProcessOutput output = parser.createOutput();
            try (Closer c = Closer.create();){
                c.register((Closeable)output);
                this.convertUsingApis(options, output);
            }
            finally {
                parser.handleOutput(output);
            }
        }
    }

    private void convertUsingApis(JackProcessOptions options, ProcessOutput output) throws ToolchainException, ClassNotFoundException, ProcessException {
        if (options.getUseJill()) {
            this.convertUsingJillApis(options);
        } else {
            this.convertUsingJackApis(options, output);
        }
    }

    private void convertUsingJackApis(JackProcessOptions options, ProcessOutput output) throws ClassNotFoundException, ToolchainException {
        BuildToolsServiceLoader.BuildToolServiceLoader buildToolServiceLoader = BuildToolsServiceLoader.INSTANCE.forVersion(this.buildToolInfo);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JackProvider jackProvider = buildToolServiceLoader.getSingleService(this.logger, BuildToolsServiceLoader.JACK).orElseThrow(() -> new IllegalStateException("Cannot load Jill from build tools."));
        BuildToolInfo.JackVersion apiVersion = this.buildToolInfo.getSupportedJackApi();
        try {
            Api04Config config = this.createJackConfig(jackProvider, apiVersion);
            config.setDebugInfoLevel(options.isDebuggable() ? DebugInfoLevel.FULL : DebugInfoLevel.NONE);
            config.setClasspath(options.getClasspaths());
            if (options.getDexOutputDirectory() != null) {
                config.setOutputDexDir(options.getDexOutputDirectory());
            }
            if (options.getOutputFile() != null) {
                config.setOutputJackFile(options.getOutputFile());
            }
            config.setImportedJackLibraryFiles(options.getImportFiles());
            if (!DefaultApiVersion.isPreview(options.getMinSdkVersion())) {
                config.setAndroidMinApiLevel(options.getMinSdkVersion().getApiLevel());
            }
            config.setProguardConfigFiles(options.getProguardFiles());
            config.setJarJarConfigFiles(options.getJarJarRuleFiles());
            if (options.isMultiDex()) {
                if (DefaultApiVersion.isLegacyMultidex(options.getMinSdkVersion())) {
                    config.setMultiDexKind(MultiDexKind.LEGACY);
                } else {
                    config.setMultiDexKind(MultiDexKind.NATIVE);
                }
            }
            config.setSourceEntries(options.getInputFiles());
            if (options.getMappingFile() != null) {
                config.setProperty("jack.obfuscation.mapping.dump", "true");
                config.setObfuscationMappingOutputFile(options.getMappingFile());
            }
            config.setProperty("jack.import.type.policy", "keep-first");
            config.setProperty("jack.import.resource.policy", "keep-first");
            config.setReporter(ReporterKind.SDK, output.getStandardOutput());
            if (options.getSourceCompatibility() != null) {
                config.setProperty("jack.java.source.version", options.getSourceCompatibility());
            }
            if (options.getIncrementalDir() != null && options.getIncrementalDir().exists()) {
                config.setIncrementalDir(options.getIncrementalDir());
            }
            ImmutableList.Builder resourcesDir = ImmutableList.builder();
            for (File file : options.getResourceDirectories()) {
                if (!file.exists()) continue;
                resourcesDir.add((Object)file);
            }
            config.setResourceDirs((List)resourcesDir.build());
            config.setProperty("jack.dex.optimize", "true");
            if (!options.getAnnotationProcessorNames().isEmpty()) {
                config.setProcessorNames(options.getAnnotationProcessorNames());
            }
            if (options.getAnnotationProcessorOutputDirectory() != null) {
                FileUtils.mkdirs((File)options.getAnnotationProcessorOutputDirectory());
                config.setProperty("jack.annotation-processor.source.output", options.getAnnotationProcessorOutputDirectory().getAbsolutePath());
            }
            try {
                config.setProcessorPath(options.getAnnotationProcessorClassPath());
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Could not resolve annotation processor path.", new Object[0]);
                throw new RuntimeException(e);
            }
            config.setProcessorOptions(options.getAnnotationProcessorOptions());
            for (String paramKey : options.getAdditionalParameters().keySet()) {
                String paramValue = options.getAdditionalParameters().get(paramKey);
                config.setProperty(paramKey, paramValue);
            }
            if (apiVersion.getVersion() >= BuildToolInfo.JackVersion.V4.getVersion()) {
                config = this.api04Specific(config, options);
            }
            config.getTask().run();
            this.logger.verbose("Jack created dex: %1$s", new Object[]{outputStream.toString()});
        }
        catch (ConfigNotSupportedException e) {
            String errorMessage = String.format("jack.jar from build tools %s does not support Jack API v%d.", this.buildToolInfo.getRevision().toString(), apiVersion.getVersion());
            throw new ToolchainException(errorMessage, e);
        }
        catch (ConfigurationException e) {
            StringBuilder stringBuilder = new StringBuilder("Jack configuration exception.");
            Iterator iterator = e.iterator();
            while (iterator.hasNext()) {
                ChainedException i = (ChainedException)iterator.next();
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append(i.getMessage());
            }
            throw new ToolchainException(stringBuilder.toString(), e);
        }
        catch (UnrecoverableException e) {
            throw new ToolchainException("Something out of Jack control has happened: " + e.getMessage(), e);
        }
        catch (CompilationException e) {
            throw new ToolchainException("Jack compilation exception", e);
        }
    }

    private void convertUsingCli(JackProcessOptions options, ProcessOutputHandler processOutputHandler, JavaProcessExecutor javaProcessExecutor) throws ProcessException {
        if (options.getUseJill()) {
            this.convertUsingJillCli(options, processOutputHandler, javaProcessExecutor);
        } else {
            this.convertUsingJackCli(options, processOutputHandler, javaProcessExecutor);
        }
    }

    private void convertUsingJackCli(JackProcessOptions options, ProcessOutputHandler processOutputHandler, JavaProcessExecutor javaProcessExecutor) throws ProcessException {
        JackProcessBuilder builder = new JackProcessBuilder(options, this.logger);
        javaProcessExecutor.execute(builder.build(this.buildToolInfo), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    private Api04Config createJackConfig(JackProvider jackProvider, BuildToolInfo.JackVersion apiVersion) throws ConfigNotSupportedException {
        if (apiVersion == BuildToolInfo.JackVersion.V4) {
            return (Api04Config)jackProvider.createConfig(Api04Config.class);
        }
        throw new RuntimeException("Cannot determine Jack API version to use = " + apiVersion);
    }

    private Api04Config api04Specific(Api04Config config, JackProcessOptions options) throws ConfigurationException {
        if (options.getCoverageMetadataFile() != null) {
            String coveragePluginPath = this.buildToolInfo.getPath(BuildToolInfo.PathId.JACK_COVERAGE_PLUGIN);
            if (coveragePluginPath == null) {
                this.logger.warning("Unknown path id %s.  Disabling code coverage.", new Object[]{BuildToolInfo.PathId.JACK_COVERAGE_PLUGIN});
            } else {
                File coveragePlugin = new File(coveragePluginPath);
                if (!coveragePlugin.isFile()) {
                    this.logger.warning("Unable to find coverage plugin '%s'.  Disabling code coverage.", new Object[]{coveragePlugin.getAbsolutePath()});
                } else {
                    options.addJackPluginClassPath(new File(coveragePluginPath));
                    options.addJackPluginName("com.android.jack.coverage.CodeCoverage");
                    config.setProperty("jack.coverage.metadata.file", options.getCoverageMetadataFile().getAbsolutePath());
                    config.setProperty("jack.coverage", "true");
                }
            }
        }
        config.setPluginNames((List)Lists.newArrayList(options.getJackPluginNames()));
        config.setPluginPath(options.getJackPluginClassPath());
        if (options.getEncoding() != null) {
            config.setDefaultCharset(Charset.forName(options.getEncoding()));
        }
        return config;
    }

    private void convertUsingJillApis(JackProcessOptions jackOptions) throws ClassNotFoundException, ToolchainException {
        Preconditions.checkState((jackOptions.getImportFiles().size() == 1 ? 1 : 0) != 0, (Object)"Jill can convert a file at a time.");
        Preconditions.checkNotNull((Object)jackOptions.getOutputFile(), (Object)"Jill output file is required.");
        BuildToolsServiceLoader.BuildToolServiceLoader buildToolServiceLoader = BuildToolsServiceLoader.INSTANCE.forVersion(this.buildToolInfo);
        JillProvider jillProvider = buildToolServiceLoader.getSingleService(this.logger, BuildToolsServiceLoader.JILL).orElseThrow(() -> new IllegalStateException("Cannot load Jill from build tools."));
        File inputFile = jackOptions.getImportFiles().get(0);
        try {
            Api01Config config = (Api01Config)jillProvider.createConfig(Api01Config.class);
            config.setInputJavaBinaryFile(inputFile);
            config.setOutputJackFile(jackOptions.getOutputFile());
            config.setVerbose(jackOptions.isVerbose());
            Api01TranslationTask translationTask = config.getTask();
            translationTask.run();
        }
        catch (com.android.jill.api.ConfigNotSupportedException e) {
            String errorMessage = String.format("jill.jar from build tools %s does not support Jill API v1.", this.buildToolInfo.getRevision().toString());
            throw new ToolchainException(errorMessage, e);
        }
        catch (com.android.jill.api.v01.ConfigurationException e) {
            throw new ToolchainException("Jill APIs v1 configuration failed", e);
        }
        catch (TranslationException e) {
            throw new ToolchainException("Jill translation aborted", e);
        }
    }

    private void convertUsingJillCli(JackProcessOptions jackOptions, ProcessOutputHandler outputHandler, JavaProcessExecutor javaProcessExecutor) throws ProcessException {
        Preconditions.checkState((jackOptions.getImportFiles().size() == 1 ? 1 : 0) != 0, (Object)"Jill can convert a file at a time.");
        Preconditions.checkNotNull((Object)jackOptions.getOutputFile(), (Object)"Jill output file is required.");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String jill = this.buildToolInfo.getPath(BuildToolInfo.PathId.JILL);
        if (jill == null || !Files.isRegularFile(Paths.get(jill, new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("jill.jar is missing from the build tools.");
        }
        builder.setClasspath(jill);
        builder.setMain("com.android.jill.Main");
        if (jackOptions.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + jackOptions.getJavaMaxHeapSize());
        }
        builder.addArgs(jackOptions.getImportFiles().get(0).getAbsolutePath());
        builder.addArgs("--output");
        builder.addArgs(jackOptions.getOutputFile().getAbsolutePath());
        if (jackOptions.isVerbose()) {
            builder.addArgs("--verbose");
        }
        this.logger.verbose(builder.toString(), new Object[0]);
        JavaProcessInfo javaProcessInfo = builder.createJavaProcess();
        ProcessResult result = javaProcessExecutor.execute(javaProcessInfo, outputHandler);
        result.rethrowFailure().assertNormalExitValue();
    }

    public static class ToolchainException
    extends Exception {
        public ToolchainException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

