/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.JackProcessOptions;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.stream.Collectors;

public class JackProcessBuilder
extends ProcessEnvBuilder<JackProcessBuilder> {
    private final JackProcessOptions options;
    private final ILogger logger;

    public JackProcessBuilder(JackProcessOptions options, ILogger logger) {
        this.options = options;
        this.logger = logger;
    }

    public JavaProcessInfo build(BuildToolInfo buildToolInfo) throws ProcessException {
        BuildToolInfo.JackVersion apiVersion;
        String jackJar;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String jackLocation = System.getenv("USE_JACK_LOCATION");
        String string = jackJar = jackLocation != null ? jackLocation + File.separator + "jack.jar" : buildToolInfo.getPath(BuildToolInfo.PathId.JACK);
        if (jackJar == null || !new File(jackJar).isFile()) {
            throw new IllegalStateException("Unable to find jack.jar at " + jackJar);
        }
        builder.setClasspath(jackJar);
        builder.setMain("com.android.jack.Main");
        if (this.options.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + this.options.getJavaMaxHeapSize());
        } else {
            builder.addJvmArg("-Xmx1024M");
        }
        builder.addJvmArg("-Dfile.encoding=" + this.options.getEncoding());
        builder.addArgs("-D", "jack.dex.optimize=true");
        if (this.options.isDebugLog()) {
            builder.addJvmArg("-Dcom.android.jack.log=DEBUG");
        } else if (this.options.isVerbose()) {
            builder.addArgs("--verbose", "info");
        }
        builder.addArgs("-D", "jack.reporter=sdk");
        builder.addArgs("-D", "jack.dex.debug.vars=" + this.options.isDebuggable());
        if (!this.options.getClasspaths().isEmpty()) {
            builder.addArgs("--classpath", FileUtils.joinFilePaths(this.options.getClasspaths()));
        }
        for (File lib : this.options.getImportFiles()) {
            builder.addArgs("--import", lib.getAbsolutePath());
        }
        if (this.options.getDexOutputDirectory() != null) {
            builder.addArgs("--output-dex", this.options.getDexOutputDirectory().getAbsolutePath());
        }
        if (this.options.getOutputFile() != null) {
            builder.addArgs("--output-jack", this.options.getOutputFile().getAbsolutePath());
        }
        builder.addArgs("-D", "jack.import.type.policy=keep-first");
        builder.addArgs("-D", "jack.import.resource.policy=keep-first");
        for (File file : this.options.getProguardFiles()) {
            builder.addArgs("--config-proguard", file.getAbsolutePath());
        }
        if (this.options.getMappingFile() != null) {
            builder.addArgs("-D", "jack.obfuscation.mapping.dump=true");
            builder.addArgs("-D", "jack.obfuscation.mapping.dump.file=" + this.options.getMappingFile().getAbsolutePath());
        }
        if (this.options.isMultiDex()) {
            builder.addArgs("--multi-dex");
            if (DefaultApiVersion.isLegacyMultidex(this.options.getMinSdkVersion())) {
                builder.addArgs("legacy");
            } else {
                builder.addArgs("native");
            }
        }
        for (File jarjarRuleFile : this.options.getJarJarRuleFiles()) {
            builder.addArgs("--config-jarjar", jarjarRuleFile.getAbsolutePath());
        }
        if (this.options.getSourceCompatibility() != null) {
            builder.addArgs("-D", "jack.java.source.version=" + this.options.getSourceCompatibility());
        }
        if (this.options.getIncrementalDir() != null && this.options.getIncrementalDir().exists()) {
            builder.addArgs("--incremental-folder", this.options.getIncrementalDir().getAbsolutePath());
        }
        if (!DefaultApiVersion.isPreview(this.options.getMinSdkVersion())) {
            builder.addArgs("-D", "jack.android.min-api-level=" + this.options.getMinSdkVersion().getApiLevel());
        }
        if (!this.options.getAnnotationProcessorNames().isEmpty()) {
            builder.addArgs("-D", "jack.annotation-processor.manual=true");
            builder.addArgs("-D", "jack.annotation-processor.manual.list=" + Joiner.on((char)',').join(this.options.getAnnotationProcessorNames()));
        }
        if (!this.options.getAnnotationProcessorClassPath().isEmpty()) {
            builder.addArgs("-D", "jack.annotation-processor.path=true");
            builder.addArgs("-D", "jack.annotation-processor.path.list=" + FileUtils.joinFilePaths(this.options.getAnnotationProcessorClassPath()));
        }
        if (!this.options.getAnnotationProcessorOptions().isEmpty()) {
            String processorOptions = this.options.getAnnotationProcessorOptions().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            builder.addArgs("-D", "jack.annotation-processor.options=" + processorOptions);
        }
        if (this.options.getAnnotationProcessorOutputDirectory() != null) {
            FileUtils.mkdirs((File)this.options.getAnnotationProcessorOutputDirectory());
            builder.addArgs("-D", "jack.annotation-processor.source.output=" + this.options.getAnnotationProcessorOutputDirectory().getAbsolutePath());
        }
        if (!this.options.getInputFiles().isEmpty()) {
            if (this.options.getEcjOptionFile() != null) {
                try {
                    this.createEcjOptionFile();
                }
                catch (IOException e) {
                    throw new ProcessException("Unable to create " + this.options.getEcjOptionFile() + ".");
                }
                builder.addArgs("@" + this.options.getEcjOptionFile().getAbsolutePath());
            } else {
                for (File file : this.options.getInputFiles()) {
                    builder.addArgs(file.getAbsolutePath());
                }
            }
        }
        if ((apiVersion = buildToolInfo.getSupportedJackApi()).getVersion() >= BuildToolInfo.JackVersion.V4.getVersion()) {
            this.api04Specific(buildToolInfo, builder);
        }
        for (String paramKey : this.options.getAdditionalParameters().keySet()) {
            String paramValue = this.options.getAdditionalParameters().get(paramKey);
            builder.addArgs("-D", paramKey + "=" + paramValue);
        }
        return builder.createJavaProcess();
    }

    private void api04Specific(BuildToolInfo buildToolInfo, ProcessInfoBuilder builder) {
        if (this.options.getCoverageMetadataFile() != null) {
            String coveragePluginPath = buildToolInfo.getPath(BuildToolInfo.PathId.JACK_COVERAGE_PLUGIN);
            if (coveragePluginPath == null || !new File(coveragePluginPath).isFile()) {
                this.logger.warning("Unable to find coverage plugin '%s'.  Disabling code coverage.", new Object[]{coveragePluginPath});
            } else {
                this.options.addJackPluginClassPath(new File(coveragePluginPath));
                this.options.addJackPluginName("com.android.jack.coverage.CodeCoverage");
                builder.addArgs("-D", "jack.coverage.metadata.file=" + this.options.getCoverageMetadataFile().getAbsolutePath());
                builder.addArgs("-D", "jack.coverage=true");
            }
        }
        if (!this.options.getJackPluginClassPath().isEmpty()) {
            builder.addArgs("--pluginpath", FileUtils.joinFilePaths(this.options.getJackPluginClassPath()));
        }
        if (!this.options.getJackPluginNames().isEmpty()) {
            builder.addArgs("--plugin", Joiner.on((String)",").join(this.options.getJackPluginNames()));
        }
    }

    private void createEcjOptionFile() throws IOException {
        Preconditions.checkNotNull((Object)this.options.getEcjOptionFile());
        StringBuilder sb = new StringBuilder();
        for (File sourceFile : this.options.getInputFiles()) {
            sb.append('\"').append(FileUtils.toSystemIndependentPath((String)sourceFile.getAbsolutePath())).append('\"').append("\n");
        }
        FileUtils.mkdirs((File)this.options.getEcjOptionFile().getParentFile());
        Files.write((CharSequence)sb.toString(), (File)this.options.getEcjOptionFile(), (Charset)Charsets.UTF_8);
    }
}

