/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.ManifestAttributeSupplier;
import com.android.manifmerger.PlaceholderHandler;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultManifestParser
implements ManifestAttributeSupplier {
    private final Map<String, String> attributeValues;

    public DefaultManifestParser(File manifestFile) {
        if (!manifestFile.exists()) {
            this.attributeValues = Maps.newHashMap();
        } else {
            HashSet xPaths = Sets.newHashSet((Object[])new String[]{AndroidManifest.getPackageXPath(), AndroidManifest.getSplitXPath(), AndroidManifest.getVersionNameXPath(), AndroidManifest.getVersionCodeXPath(), AndroidManifest.getMinSdkVersionXPath(), AndroidManifest.getTargetSdkVersionXPath(), AndroidManifest.getInstrumentationRunnerXPath(), AndroidManifest.getTestTargetPackageXPath(), AndroidManifest.getTestFunctionalTestXPath(), AndroidManifest.getTestHandleProfilingXPath(), AndroidManifest.getTestLabelXPath(), AndroidManifest.getExtractNativeLibsXPath()});
            this.attributeValues = DefaultManifestParser.getStringValues(manifestFile, xPaths);
        }
    }

    @Override
    public String getPackage() {
        return this.attributeValues.get(AndroidManifest.getPackageXPath());
    }

    @Override
    public String getSplit() {
        return this.attributeValues.get(AndroidManifest.getSplitXPath());
    }

    @Override
    public String getVersionName() {
        return this.attributeValues.get(AndroidManifest.getVersionNameXPath());
    }

    @Override
    public int getVersionCode() {
        String versionCode = this.attributeValues.get(AndroidManifest.getVersionCodeXPath());
        return (Integer)DefaultManifestParser.parseIntValueOrDefault(versionCode, -1, -1);
    }

    @Override
    public Object getMinSdkVersion() {
        String minSdkVersion = this.attributeValues.get(AndroidManifest.getMinSdkVersionXPath());
        return DefaultManifestParser.parseIntValueOrDefault(minSdkVersion, minSdkVersion, 1);
    }

    @Override
    public Object getTargetSdkVersion() {
        String targetSdkVersion = this.attributeValues.get(AndroidManifest.getTargetSdkVersionXPath());
        return DefaultManifestParser.parseIntValueOrDefault(targetSdkVersion, targetSdkVersion, -1);
    }

    @Override
    public String getInstrumentationRunner() {
        return this.attributeValues.get(AndroidManifest.getInstrumentationRunnerXPath());
    }

    @Override
    public String getTargetPackage() {
        return this.attributeValues.get(AndroidManifest.getTestTargetPackageXPath());
    }

    @Override
    public Boolean getFunctionalTest() {
        String functionalTest = this.attributeValues.get(AndroidManifest.getTestFunctionalTestXPath());
        return DefaultManifestParser.parseBoolean(functionalTest);
    }

    @Override
    public Boolean getHandleProfiling() {
        String handleProfiling = this.attributeValues.get(AndroidManifest.getTestHandleProfilingXPath());
        return DefaultManifestParser.parseBoolean(handleProfiling);
    }

    @Override
    public String getTestLabel() {
        return this.attributeValues.get(AndroidManifest.getTestLabelXPath());
    }

    @Override
    public Boolean getExtractNativeLibs() {
        String extractNativeLibs = this.attributeValues.get(AndroidManifest.getExtractNativeLibsXPath());
        return DefaultManifestParser.parseBoolean(extractNativeLibs);
    }

    private static Object parseIntValueOrDefault(String value, Object ifNotInt, Object ifNull) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                return ifNotInt;
            }
        }
        return ifNull;
    }

    private static Boolean parseBoolean(String value) {
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private static Map<String, String> getStringValues(File file, Set<String> xPaths) {
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
            HashMap pathsToVals = Maps.newHashMap();
            for (String path : xPaths) {
                XPath xpath = AndroidXPathFactory.newXPath();
                Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
                String nodeValue = null;
                if (node != null && !Strings.isNullOrEmpty((String)node.getNodeValue()) && !PlaceholderHandler.isPlaceHolder((String)node.getNodeValue())) {
                    nodeValue = node.getNodeValue();
                }
                pathsToVals.put(path, nodeValue);
            }
            return pathsToVals;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new DefaultManifestParserException(file, (Throwable)e);
        }
    }

    private static class DefaultManifestParserException
    extends RuntimeException {
        DefaultManifestParserException(File file, Throwable cause) {
            super("Exception while parsing the supplied manifest file " + file.getAbsolutePath(), cause);
        }
    }
}

