/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.compress;

import com.android.builder.internal.packaging.zip.CompressionResult;
import com.android.builder.internal.packaging.zip.compress.DeflateExecutionCompressor;
import com.android.builder.internal.packaging.zip.compress.ExecutorCompressor;
import com.android.builder.internal.packaging.zip.utils.ByteTracker;
import com.android.builder.internal.packaging.zip.utils.CloseableByteSource;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;

public class BestAndDefaultDeflateExecutorCompressor
extends ExecutorCompressor {
    private final DeflateExecutionCompressor mDefaultDeflater;
    private final DeflateExecutionCompressor mBestDeflater;
    private final double mMinRatio;

    public BestAndDefaultDeflateExecutorCompressor(Executor executor, ByteTracker tracker, double minRatio) {
        super(executor);
        Preconditions.checkArgument((minRatio >= 0.0 ? 1 : 0) != 0, (Object)"minRatio < 0.0");
        Preconditions.checkArgument((minRatio <= 1.0 ? 1 : 0) != 0, (Object)"minRatio > 1.0");
        this.mDefaultDeflater = new DeflateExecutionCompressor(executor, tracker, -1);
        this.mBestDeflater = new DeflateExecutionCompressor(executor, tracker, 9);
        this.mMinRatio = minRatio;
    }

    @Override
    protected CompressionResult immediateCompress(CloseableByteSource source) throws Exception {
        CompressionResult defaultResult = this.mDefaultDeflater.immediateCompress(source);
        CompressionResult bestResult = this.mBestDeflater.immediateCompress(source);
        double sizeRatio = (double)bestResult.getSize() / (double)defaultResult.getSize();
        if (sizeRatio >= this.mMinRatio) {
            return defaultResult;
        }
        return bestResult;
    }
}

