/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.AlignmentRule;
import com.google.common.base.Preconditions;

public final class AlignmentRules {
    private AlignmentRules() {
    }

    public static AlignmentRule constant(int alignment) {
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return path -> alignment;
    }

    public static AlignmentRule constantForSuffix(String suffix, int alignment) {
        Preconditions.checkArgument((!suffix.isEmpty() ? 1 : 0) != 0, (Object)"suffix.isEmpty()");
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return path -> path.endsWith(suffix) ? alignment : 1;
    }

    public static AlignmentRule compose(AlignmentRule ... rules) {
        return path -> {
            for (AlignmentRule r : rules) {
                int align = r.alignment(path);
                if (align == 1) continue;
                return align;
            }
            return 1;
        };
    }
}

