/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.RelativeFile;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Function;
import com.google.common.base.Objects;

class PackagedFileUpdate {
    static final Function<PackagedFileUpdate, String> EXTRACT_NAME = new Function<PackagedFileUpdate, String>(){

        public String apply(PackagedFileUpdate input) {
            return input.getName();
        }
    };
    static final Function<PackagedFileUpdate, FileStatus> EXTRACT_STATUS = new Function<PackagedFileUpdate, FileStatus>(){

        public FileStatus apply(PackagedFileUpdate input) {
            return input.getStatus();
        }
    };
    static final Function<PackagedFileUpdate, RelativeFile> EXTRACT_SOURCE = new Function<PackagedFileUpdate, RelativeFile>(){

        public RelativeFile apply(PackagedFileUpdate input) {
            return input.getSource();
        }
    };
    private final RelativeFile mSource;
    private final String mName;
    private final FileStatus mStatus;

    PackagedFileUpdate(RelativeFile source, String name, FileStatus status) {
        this.mSource = source;
        this.mName = name;
        this.mStatus = status;
    }

    public RelativeFile getSource() {
        return this.mSource;
    }

    public String getName() {
        return this.mName;
    }

    public FileStatus getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackagedFileUpdate that = (PackagedFileUpdate)o;
        return Objects.equal((Object)this.mSource, (Object)that.mSource) && Objects.equal((Object)this.mName, (Object)that.mName) && this.mStatus == that.mStatus;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSource, this.mName, this.mStatus});
    }
}

