/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v1;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.internal.aapt.AbstractProcessExecutionAapt;
import com.android.builder.model.AaptOptions;
import com.android.builder.png.QueuedCruncher;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AaptV1
extends AbstractProcessExecutionAapt {
    private static final long AUTO_THREAD_SHUTDOWN_MS = 250L;
    static final Revision VERSION_FOR_SERVER_AAPT = new Revision(22, 0, 0);
    private final BuildToolInfo mBuildToolInfo;
    private final QueuedCruncher mCruncher;
    private final Executor mWaitExecutor;
    private final PngProcessMode mProcessMode;

    public AaptV1(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, ILogger logger, PngProcessMode processMode, int cruncherProcesses) {
        super(processExecutor, processOutputHandler);
        this.mBuildToolInfo = buildToolInfo;
        this.mWaitExecutor = new ThreadPoolExecutor(0, 1, 250L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.mProcessMode = processMode;
        this.mCruncher = buildToolInfo.getRevision().compareTo(VERSION_FOR_SERVER_AAPT) >= 0 ? QueuedCruncher.Builder.INSTANCE.newCruncher(this.getAaptExecutablePath(), logger, cruncherProcesses) : null;
    }

    @Override
    protected ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig config) throws AaptException {
        ArrayList otherResourceConfigs;
        List additionalParameters;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("package");
        if (config.isVerbose()) {
            builder.addArgs("-v");
        }
        builder.addArgs("-f");
        builder.addArgs("--no-crunch");
        IAndroidTarget target = config.getAndroidTarget();
        Preconditions.checkNotNull((Object)target);
        builder.addArgs("-I", target.getPath(1));
        File manifestFile = config.getManifestFile();
        Preconditions.checkNotNull((Object)manifestFile);
        builder.addArgs("-M", manifestFile.getAbsolutePath());
        if (config.getResourceDir() != null) {
            builder.addArgs("-S", config.getResourceDir().getAbsolutePath());
        }
        if (config.getSourceOutputDir() != null) {
            builder.addArgs("-m");
            builder.addArgs("-J", config.getSourceOutputDir().getAbsolutePath());
        }
        if (config.getResourceOutputApk() != null) {
            builder.addArgs("-F", config.getResourceOutputApk().getAbsolutePath());
        }
        if (config.getProguardOutputFile() != null) {
            builder.addArgs("-G", config.getProguardOutputFile().getAbsolutePath());
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            Preconditions.checkState((this.mBuildToolInfo.getRevision().compareTo(VERSION_FOR_MAIN_DEX_LIST) >= 0 ? 1 : 0) != 0, (String)"AAPT<%s cannot compute the main dex list", (Object[])new Object[]{VERSION_FOR_MAIN_DEX_LIST});
            builder.addArgs("-D", config.getMainDexListProguardOutputFile().getAbsolutePath());
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                builder.addArgs("--split", split);
            }
        }
        if (config.isDebuggable()) {
            builder.addArgs("--debug-mode");
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.addArgs("--custom-package", config.getCustomPackageForR());
            logger.verbose("Custom package for R class: '%s'", new Object[]{config.getCustomPackageForR()});
        }
        if (config.isPseudoLocalize()) {
            Preconditions.checkState((this.mBuildToolInfo.getRevision().getMajor() >= 21 ? 1 : 0) != 0);
            builder.addArgs("--pseudo-localize");
        }
        if (config.getVariantType() == VariantType.LIBRARY) {
            builder.addArgs("--non-constant-id");
        }
        AaptOptions options = config.getOptions();
        Preconditions.checkNotNull((Object)options);
        String ignoreAssets = options.getIgnoreAssets();
        if (ignoreAssets != null) {
            builder.addArgs("--ignore-assets", ignoreAssets);
        }
        if (config.getOptions().getFailOnMissingConfigEntry()) {
            Preconditions.checkState((this.mBuildToolInfo.getRevision().getMajor() > 20 ? 1 : 0) != 0);
            builder.addArgs("--error-on-missing-config-entry");
        }
        builder.addArgs("-0", "apk");
        Collection noCompressList = config.getOptions().getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.addArgs("-0", noCompress);
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addArgs(additionalParameters);
        }
        ArrayList resourceConfigs = new ArrayList();
        resourceConfigs.addAll(config.getResourceConfigs());
        if (this.mBuildToolInfo.getRevision().getMajor() < 21 && config.getPreferredDensity() != null) {
            resourceConfigs.add(config.getPreferredDensity());
            resourceConfigs.add((String)Density.NODPI.getResourceValue());
        }
        String preferredDensity = null;
        if (this.mBuildToolInfo.getRevision().getMajor() >= 21) {
            ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
            otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
            preferredDensity = config.getPreferredDensity();
            if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
                throw new AaptException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
            }
            if (densityResourceConfigs.size() > 1) {
                throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
            }
            if (preferredDensity == null && densityResourceConfigs.size() == 1) {
                preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
            }
        } else {
            otherResourceConfigs = resourceConfigs;
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.addArgs("-c", joiner.join((Iterable)otherResourceConfigs));
        }
        if (preferredDensity != null) {
            builder.addArgs("--preferred-density", preferredDensity);
        }
        if (!(config.getSymbolOutputDir() == null || config.getVariantType() != VariantType.LIBRARY && config.getLibraries().isEmpty())) {
            builder.addArgs("--output-text-symbols", config.getSymbolOutputDir().getAbsolutePath());
        }
        if (this.mBuildToolInfo.getRevision().getMajor() >= 23) {
            builder.addArgs("--no-version-vectors");
        }
        return builder;
    }

    @Override
    public ListenableFuture<File> compile(File file, File output) throws AaptException {
        SettableFuture compilationFuture;
        if (ResourceFolderType.getFolderType((String)file.getParentFile().getName()) == ResourceFolderType.RAW) {
            return Futures.immediateFuture(null);
        }
        if (this.mCruncher == null) {
            compilationFuture = super.compile(file, output);
        } else {
            SettableFuture future;
            Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
            Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
            compilationFuture = future = SettableFuture.create();
            if (!this.mProcessMode.shouldProcess(file)) {
                future.set(null);
            } else {
                File outputFile = AaptV1.compileOutputFor(file, output);
                try {
                    Files.createParentDirs((File)outputFile);
                }
                catch (IOException e) {
                    throw new AaptException(e, String.format("Failed to create parent directories for file '%s'", output.getAbsolutePath()), new Object[0]);
                }
                int key = this.mCruncher.start();
                try {
                    this.mCruncher.crunchPng(key, file, outputFile);
                }
                catch (PngException e) {
                    throw new AaptException(e, String.format("Failed to crunch file '%s' into '%s'", file.getAbsolutePath(), outputFile.getAbsolutePath()), new Object[0]);
                }
                this.mWaitExecutor.execute(() -> {
                    try {
                        this.mCruncher.end(key);
                        future.set((Object)outputFile);
                    }
                    catch (Exception e) {
                        future.setException((Throwable)e);
                    }
                });
            }
        }
        if (file.getName().endsWith(".9.png")) {
            return compilationFuture;
        }
        return Futures.transform((ListenableFuture)compilationFuture, result -> {
            SettableFuture returnFuture = SettableFuture.create();
            try {
                if (result != null && file.length() < result.length()) {
                    Files.copy((File)file, (File)result);
                }
                returnFuture.set(result);
            }
            catch (Exception e) {
                returnFuture.setException((Throwable)e);
            }
            return returnFuture;
        });
    }

    @Override
    protected AbstractProcessExecutionAapt.CompileInvocation makeCompileProcessBuilder(File file, File output) throws AaptException {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!directory.isDirectory()");
        if (!file.getName().endsWith(".png")) {
            return null;
        }
        if (!this.mProcessMode.shouldProcess(file)) {
            return null;
        }
        File outputFile = AaptV1.compileOutputFor(file, output);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("singleCrunch");
        builder.addArgs("-i", file.getAbsolutePath());
        builder.addArgs("-o", outputFile.getAbsolutePath());
        return new AbstractProcessExecutionAapt.CompileInvocation(builder, outputFile);
    }

    private static File compileOutputFor(File file, File output) {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
        File parentDir = new File(output, file.getParentFile().getName());
        FileUtils.mkdirs((File)parentDir);
        return new File(parentDir, file.getName());
    }

    private String getAaptExecutablePath() {
        String aapt = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing on '" + aapt + "'");
        }
        return aapt;
    }

    public static enum PngProcessMode {
        ALL{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".png");
            }
        }
        ,
        NINE_PATCH_ONLY{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".9.png");
            }
        }
        ,
        NONE{

            @Override
            public boolean shouldProcess(File file) {
                return false;
            }
        };


        public abstract boolean shouldProcess(File var1);
    }
}

