/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.Token;

public class SQLParser {
    protected final Lexer lexer;
    protected String dbType;
    private int errorEndPos = -1;

    public SQLParser(String sql, String dbType) {
        this(new Lexer(sql, null, dbType), dbType);
        this.lexer.nextToken();
    }

    public SQLParser(String sql) {
        this(sql, null);
    }

    public SQLParser(Lexer lexer) {
        this(lexer, null);
    }

    public SQLParser(Lexer lexer, String dbType) {
        this.lexer = lexer;
        this.dbType = dbType;
    }

    public final Lexer getLexer() {
        return this.lexer;
    }

    public String getDbType() {
        return this.dbType;
    }

    protected boolean identifierEquals(String text) {
        return this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase(text);
    }

    protected void acceptIdentifier(String text) {
        if (!this.identifierEquals(text)) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + text + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }

    protected String as() {
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            alias = this.alias();
            if (alias != null) {
                while (this.lexer.token() == Token.DOT) {
                    this.lexer.nextToken();
                    alias = alias + '.' + this.lexer.token().name();
                    this.lexer.nextToken();
                }
                return alias;
            }
            if (this.lexer.token() == Token.LPAREN) {
                return null;
            }
            throw new ParserException("Error : " + (Object)((Object)this.lexer.token()));
        }
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            alias = '\"' + this.lexer.stringVal() + '\"';
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.LITERAL_CHARS) {
            alias = "'" + this.lexer.stringVal() + "'";
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.CASE) {
            alias = this.lexer.token.name();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.USER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.END) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        }
        switch (this.lexer.token()) {
            case KEY: 
            case INTERVAL: 
            case CONSTRAINT: {
                alias = this.lexer.token().name();
                this.lexer.nextToken();
                return alias;
            }
        }
        return alias;
    }

    protected String alias() {
        String alias = null;
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            alias = '\"' + this.lexer.stringVal() + '\"';
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.LITERAL_CHARS) {
            alias = "'" + this.lexer.stringVal() + "'";
            this.lexer.nextToken();
        } else {
            switch (this.lexer.token()) {
                case KEY: 
                case INTERVAL: 
                case INDEX: 
                case CASE: 
                case MODEL: 
                case PCTFREE: 
                case INITRANS: 
                case MAXTRANS: 
                case SEGMENT: 
                case CREATION: 
                case IMMEDIATE: 
                case DEFERRED: 
                case STORAGE: 
                case NEXT: 
                case MINEXTENTS: 
                case MAXEXTENTS: 
                case MAXSIZE: 
                case PCTINCREASE: 
                case FLASH_CACHE: 
                case CELL_FLASH_CACHE: 
                case KEEP: 
                case NONE: 
                case LOB: 
                case STORE: 
                case ROW: 
                case CHUNK: 
                case CACHE: 
                case NOCACHE: 
                case LOGGING: 
                case NOCOMPRESS: 
                case KEEP_DUPLICATES: 
                case EXCEPTIONS: 
                case PURGE: 
                case INITIALLY: 
                case END: 
                case COMMENT: 
                case ENABLE: 
                case DISABLE: 
                case SEQUENCE: 
                case USER: 
                case ANALYZE: 
                case OPTIMIZE: 
                case GRANT: 
                case REVOKE: 
                case FULL: 
                case TO: 
                case NEW: 
                case LOCK: 
                case LIMIT: 
                case IDENTIFIED: 
                case PASSWORD: 
                case BINARY: 
                case WINDOW: 
                case OFFSET: 
                case SHARE: 
                case START: 
                case CONNECT: 
                case MATCHED: 
                case ERRORS: 
                case REJECT: 
                case UNLIMITED: 
                case BEGIN: 
                case EXCLUSIVE: 
                case MODE: 
                case ADVISE: 
                case TYPE: 
                case CLOSE: {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    return alias;
                }
                case QUES: {
                    alias = "?";
                    this.lexer.nextToken();
                }
            }
        }
        return alias;
    }

    protected void printError(Token token) {
        String arround = this.lexer.mark >= 0 && this.lexer.text.length() > this.lexer.mark + 30 ? (this.lexer.mark - 5 > 0 ? this.lexer.text.substring(this.lexer.mark - 5, this.lexer.mark + 30) : this.lexer.text.substring(this.lexer.mark, this.lexer.mark + 30)) : (this.lexer.mark >= 0 ? (this.lexer.mark - 5 > 0 ? this.lexer.text.substring(this.lexer.mark - 5) : this.lexer.text.substring(this.lexer.mark)) : this.lexer.text);
        throw new ParserException("syntax error, error in :'" + arround + "',expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public void accept(Token token) {
        if (this.lexer.token() == token) {
            this.lexer.nextToken();
        } else {
            this.setErrorEndPos(this.lexer.pos());
            this.printError(token);
        }
    }

    public void match(Token token) {
        if (this.lexer.token() != token) {
            throw new ParserException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
    }

    protected void setErrorEndPos(int errPos) {
        if (errPos > this.errorEndPos) {
            this.errorEndPos = errPos;
        }
    }
}

