/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import org.bouncycastle.asn1.cms.EnvelopedDataParser;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    EnvelopedDataParser _envelopedData = new EnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier _encAlg;
    private AttributeTable _unprotectedAttributes;
    private boolean _attrNotRead = true;

    public CMSEnvelopedDataParser(byte[] byArray) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSEnvelopedDataParser(InputStream inputStream) throws CMSException, IOException {
        super(inputStream);
        DEREncodable dEREncodable;
        ASN1SetParser aSN1SetParser = this._envelopedData.getRecipientInfos();
        ArrayList<RecipientInfo> arrayList = new ArrayList<RecipientInfo>();
        while ((dEREncodable = aSN1SetParser.readObject()) != null) {
            arrayList.add(RecipientInfo.getInstance((Object)dEREncodable.getDERObject()));
        }
        EncryptedContentInfoParser encryptedContentInfoParser = this._envelopedData.getEncryptedContentInfo();
        this._encAlg = encryptedContentInfoParser.getContentEncryptionAlgorithm();
        ArrayList<RecipientInformation> arrayList2 = new ArrayList<RecipientInformation>();
        Iterator iterator = arrayList.iterator();
        InputStream inputStream2 = ((ASN1OctetStringParser)encryptedContentInfoParser.getEncryptedContent(4)).getOctetStream();
        while (iterator.hasNext()) {
            RecipientInfo recipientInfo = (RecipientInfo)iterator.next();
            DEREncodable dEREncodable2 = recipientInfo.getInfo();
            if (dEREncodable2 instanceof KeyTransRecipientInfo) {
                arrayList2.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)dEREncodable2, this._encAlg, inputStream2));
                continue;
            }
            if (dEREncodable2 instanceof KEKRecipientInfo) {
                arrayList2.add(new KEKRecipientInformation((KEKRecipientInfo)dEREncodable2, this._encAlg, inputStream2));
                continue;
            }
            if (dEREncodable2 instanceof KeyAgreeRecipientInfo) {
                arrayList2.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)dEREncodable2, this._encAlg, inputStream2));
                continue;
            }
            if (!(dEREncodable2 instanceof PasswordRecipientInfo)) continue;
            arrayList2.add(new PasswordRecipientInformation((PasswordRecipientInfo)dEREncodable2, this._encAlg, inputStream2));
        }
        this._recipientInfoStore = new RecipientInformationStore(arrayList2);
    }

    public String getEncryptionAlgOID() {
        return this._encAlg.getObjectId().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this._encAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), string);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this._unprotectedAttributes == null && this._attrNotRead) {
            ASN1SetParser aSN1SetParser = this._envelopedData.getUnprotectedAttrs();
            this._attrNotRead = false;
            if (aSN1SetParser != null) {
                DEREncodable dEREncodable;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((dEREncodable = aSN1SetParser.readObject()) != null) {
                    ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)dEREncodable;
                    aSN1EncodableVector.add((DEREncodable)aSN1SequenceParser.getDERObject());
                }
                this._unprotectedAttributes = new AttributeTable((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector));
            }
        }
        return this._unprotectedAttributes;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }
}

