/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public class FormHttpMessageWriter
implements HttpMessageWriter<MultiValueMap<String, String>> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final ResolvableType MULTIVALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private static final List<MediaType> MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED);
    private Charset defaultCharset = DEFAULT_CHARSET;

    public void setDefaultCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset must not be null");
        this.defaultCharset = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        Class rawClass = elementType.getRawClass();
        if (rawClass == null || !MultiValueMap.class.isAssignableFrom(rawClass)) {
            return false;
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
            return true;
        }
        if (mediaType == null) {
            return MULTIVALUE_TYPE.isAssignableFrom(elementType);
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, String>> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, Map<String, Object> hints) {
        MediaType contentType = message.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_FORM_URLENCODED;
            message.getHeaders().setContentType(contentType);
        }
        Charset charset = this.getMediaTypeCharset(contentType);
        return Mono.from(inputStream).flatMap(form -> {
            String value = this.serializeForm((MultiValueMap<String, String>)form, charset);
            ByteBuffer byteBuffer = charset.encode(value);
            DataBuffer buffer = message.bufferFactory().wrap(byteBuffer);
            message.getHeaders().setContentLength(byteBuffer.remaining());
            return message.writeWith((Publisher<? extends DataBuffer>)Mono.just((Object)buffer));
        });
    }

    private Charset getMediaTypeCharset(@Nullable MediaType mediaType) {
        if (mediaType != null && mediaType.getCharset() != null) {
            return mediaType.getCharset();
        }
        return this.getDefaultCharset();
    }

    private String serializeForm(MultiValueMap<String, String> form, Charset charset) {
        StringBuilder builder = new StringBuilder();
        try {
            Iterator names = form.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                Iterator values = ((List)form.get((Object)name)).iterator();
                while (values.hasNext()) {
                    Object rawValue = values.next();
                    builder.append(URLEncoder.encode(name, charset.name()));
                    if (rawValue == null) continue;
                    builder.append('=');
                    Assert.isInstanceOf(String.class, rawValue, (String)"FormHttpMessageWriter supports String values only. Use MultipartHttpMessageWriter for multipart requests.");
                    builder.append(URLEncoder.encode((String)rawValue, charset.name()));
                    if (!values.hasNext()) continue;
                    builder.append('&');
                }
                if (!names.hasNext()) continue;
                builder.append('&');
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return builder.toString();
    }
}

