/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancedRetryPolicy;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.retry.RetryListener;
import org.springframework.retry.backoff.BackOffPolicy;

public class RibbonLoadBalancedRetryFactory
implements LoadBalancedRetryFactory {
    private SpringClientFactory clientFactory;

    public RibbonLoadBalancedRetryFactory(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public LoadBalancedRetryPolicy createRetryPolicy(String service, ServiceInstanceChooser serviceInstanceChooser) {
        RibbonLoadBalancerContext lbContext = this.clientFactory.getLoadBalancerContext(service);
        return new RibbonLoadBalancedRetryPolicy(service, lbContext, serviceInstanceChooser, this.clientFactory.getClientConfig(service));
    }

    public RetryListener[] createRetryListeners(String service) {
        return new RetryListener[0];
    }

    public BackOffPolicy createBackOffPolicy(String service) {
        return null;
    }
}

