/*
  Copyright 2012 Jerome Leleu

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package org.scribe.up.profile.converter;

import org.scribe.up.profile.JsonHelper;

import com.fasterxml.jackson.databind.JsonNode;

/**
 * This class defines a base converter which can also convert from JSON.
 * 
 * @author Jerome Leleu
 * @since 1.1.0
 */
public abstract class BaseConverter<T> implements AttributeConverter<T> {
    
    public abstract T convert(Object attribute);
    
    /**
     * Convert an attribute from JSON.
     * 
     * @param json
     * @param name
     * @return the converted attribute.
     */
    public T convertFromJson(final JsonNode json, final String name) {
        return convert(JsonHelper.get(json, name));
    }
}
