/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TopK
extends DynamicCustomOp {
    private boolean sorted;
    private int k;

    public TopK() {
    }

    public TopK(SameDiff sd, SDVariable in, int k, boolean sorted) {
        super(sd, new SDVariable[]{in}, false);
        this.k = k;
        this.sorted = sorted;
        this.addIArgument(ArrayUtil.fromBoolean((boolean)sorted), k);
    }

    @Override
    public String opName() {
        return "top_k";
    }

    @Override
    public String tensorflowName() {
        return "TopKV2";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String thisName = nodeDef.getName();
        String inputName = thisName + "/k";
        NodeDef kNode = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (!graph.getNode(i).getName().equals(inputName)) continue;
            kNode = graph.getNode(i);
            break;
        }
        this.sorted = nodeDef.getAttrOrThrow("sorted").getB();
        if (kNode != null) {
            Preconditions.checkState((kNode != null ? 1 : 0) != 0, (String)"Could not find 'k' parameter node for op: %s", (Object)thisName);
            INDArray arr = TFGraphMapper.getNDArrayFromTensor(kNode);
            this.k = arr.getInt(0);
            this.addIArgument(ArrayUtil.fromBoolean((boolean)this.sorted), this.k);
        } else {
            this.addIArgument(ArrayUtil.fromBoolean((boolean)this.sorted));
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Arrays.asList(dataTypes.get(0), DataType.INT);
    }
}

