/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class InTopK
extends DynamicCustomOp {
    private boolean sorted;
    private int k;

    public InTopK() {
    }

    public InTopK(SameDiff sd, SDVariable predictions, SDVariable targets, int k) {
        super(sd, new SDVariable[]{predictions, targets}, false);
        this.k = k;
        this.addIArgument(k);
    }

    @Override
    public String opName() {
        return "in_top_k";
    }

    @Override
    public String tensorflowName() {
        return "InTopKV2";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String thisName = nodeDef.getName();
        String inputName = thisName + "/k";
        NodeDef kNode = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (!graph.getNode(i).getName().equals(inputName)) continue;
            kNode = graph.getNode(i);
            break;
        }
        Preconditions.checkState((kNode != null ? 1 : 0) != 0, (String)"Could not find 'k' parameter node for op: %s", (Object)thisName);
        INDArray arr = TFGraphMapper.getNDArrayFromTensor(kNode);
        this.k = arr.getInt(0);
        this.addIArgument(this.k);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 2 || dataTypes.size() == 3) ? 1 : 0) != 0, (String)"Expected 2 or 3 input datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.BOOL);
    }
}

