/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DynamicPartition
extends DynamicCustomOp {
    private int numPartitions;
    private SDVariable partitions;

    public DynamicPartition() {
    }

    public DynamicPartition(SameDiff sameDiff, SDVariable input, SDVariable partitions, int numPartitions) {
        super(null, sameDiff, new SDVariable[]{input, partitions}, false);
        this.partitions = partitions;
        this.numPartitions = numPartitions;
        this.addArgs();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Arrays.asList(this.f().dynamicPartitionBp(this.arg(0), this.arg(1), i_v.toArray(new SDVariable[i_v.size()]), this.numPartitions));
    }

    protected void addArgs() {
        this.addIArgument(this.numPartitions);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> attrs = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping numPartitions = PropertyMapping.builder().tfAttrName("num_partitions").propertyNames(new String[]{"numPartitions"}).build();
        attrs.put("numPartitions", numPartitions);
        ret.put(this.tensorflowName(), attrs);
        return ret;
    }

    @Override
    public String opName() {
        return "dynamic_partition";
    }

    @Override
    public String tensorflowName() {
        return "DynamicPartition";
    }

    @Override
    public String onnxName() {
        return "Dynamic partitioning currently not supported by ONNX";
    }

    @Override
    public int getNumOutputs() {
        return this.numPartitions;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        ArrayList<DataType> out = new ArrayList<DataType>(this.numPartitions);
        for (int i = 0; i < this.numPartitions; ++i) {
            out.add(dataTypes.get(0));
        }
        return out;
    }
}

