/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.summarystats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;

public class Variance
extends BaseReduceOp {
    protected double mean;
    protected double bias;
    protected boolean biasCorrected = true;

    public Variance(SameDiff sameDiff, SDVariable i_v, boolean biasCorrected, boolean keepDims, int[] dimensions) {
        super(sameDiff, i_v, dimensions, keepDims);
        this.biasCorrected = biasCorrected;
        this.defineDimensions(dimensions);
    }

    public Variance() {
    }

    public Variance(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }

    public Variance(INDArray x, int ... dimension) {
        this(x, true, dimension);
    }

    public Variance(INDArray x, INDArray z, boolean biasCorrected, int ... dimensions) {
        this(x, z, true, false, dimensions);
        this.biasCorrected = biasCorrected;
    }

    public Variance(INDArray x, boolean biasCorrected, int ... dimensions) {
        super(x, new int[0]);
        this.biasCorrected = biasCorrected;
        this.defineDimensions(dimensions);
    }

    public Variance(INDArray x, INDArray z, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        super(x, null, z, keepDims, dimensions);
        this.biasCorrected = biasCorrected;
        this.defineDimensions(dimensions);
    }

    @Override
    public INDArray noOp() {
        return Nd4j.zerosLike(this.x());
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String opName() {
        return "var";
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public void setBiasCorrected(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().varianceBp(this.arg(), grad.get(0), this.biasCorrected, this.keepDims, this.dimensions));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.VARIANCE;
    }

    @Override
    public DataType resultType() {
        if (this.x() != null && this.x().isR()) {
            return this.x().dataType();
        }
        if (this.arg() != null) {
            return this.arg().dataType();
        }
        return Nd4j.defaultFloatingPointType();
    }

    @Override
    public boolean validateDataTypes() {
        if (!this.x().isR()) {
            return false;
        }
        if (this.y() != null && !this.y().isR()) {
            return false;
        }
        return this.z() == null || this.z().isR();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.args().length < 1) {
            throw new ND4JIllegalStateException("Unable to compute input shape. No arguments found.");
        }
        long[] argShape = this.arg().getShape();
        if (argShape == null && this.x() == null) {
            return Collections.emptyList();
        }
        long[] inputShape = argShape == null || Shape.isPlaceholderShape(argShape) ? this.x().shape() : argShape;
        ArrayList<LongShapeDescriptor> ret = new ArrayList<LongShapeDescriptor>(1);
        long[] reducedShape = Shape.getReducedShape(inputShape, this.dimensions, this.isKeepDims());
        ret.add(LongShapeDescriptor.fromShape(reducedShape, this.resultType()));
        return ret;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.VARIANCE;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        if (dataTypes.get(0).isFPType()) {
            return dataTypes;
        }
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }
}

