/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.ColumnAndConditionCriterion;
import org.mybatis.dynamic.sql.CriteriaGroup;
import org.mybatis.dynamic.sql.ExistsCriterion;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.NotCriterion;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.SqlCriterionVisitor;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.render.ColumnAndConditionRenderer;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;

public class CriterionRenderer
implements SqlCriterionVisitor<Optional<RenderedCriterion>> {
    private final RenderingContext renderingContext;

    public CriterionRenderer(RenderingContext renderingContext) {
        this.renderingContext = Objects.requireNonNull(renderingContext);
    }

    @Override
    public <T> Optional<RenderedCriterion> visit(ColumnAndConditionCriterion<T> criterion) {
        Optional<FragmentAndParameters> initialCriterion = this.renderColumnAndCondition(criterion);
        List<RenderedCriterion> renderedSubCriteria = this.renderSubCriteria(criterion.subCriteria());
        return initialCriterion.map(fp -> this.calculateRenderedCriterion((FragmentAndParameters)fp, renderedSubCriteria, this::calculateFragment)).orElseGet(() -> this.calculateRenderedCriterion(renderedSubCriteria, this::calculateFragment));
    }

    @Override
    public Optional<RenderedCriterion> visit(ExistsCriterion criterion) {
        FragmentAndParameters initialCriterion = this.renderExists(criterion);
        List<RenderedCriterion> renderedSubCriteria = this.renderSubCriteria(criterion.subCriteria());
        return this.calculateRenderedCriterion(initialCriterion, renderedSubCriteria, this::calculateFragment);
    }

    @Override
    public Optional<RenderedCriterion> visit(CriteriaGroup criterion) {
        return this.renderCriteriaGroup(criterion, this::calculateFragment);
    }

    @Override
    public Optional<RenderedCriterion> visit(NotCriterion criterion) {
        return this.renderCriteriaGroup(criterion, this::calculateNotFragment);
    }

    private Optional<RenderedCriterion> renderCriteriaGroup(CriteriaGroup criterion, Function<FragmentCollector, String> fragmentCalculator) {
        return criterion.initialCriterion().map(ic -> this.render((SqlCriterion)ic, criterion.subCriteria(), fragmentCalculator)).orElseGet(() -> this.render(criterion.subCriteria(), fragmentCalculator));
    }

    public Optional<RenderedCriterion> render(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria, Function<FragmentCollector, String> fragmentCalculator) {
        Optional<FragmentAndParameters> fragmentAndParameters = initialCriterion.accept(this).map(RenderedCriterion::fragmentAndParameters);
        List<RenderedCriterion> renderedSubCriteria = this.renderSubCriteria(subCriteria);
        return fragmentAndParameters.map(fp -> this.calculateRenderedCriterion((FragmentAndParameters)fp, renderedSubCriteria, fragmentCalculator)).orElseGet(() -> this.calculateRenderedCriterion(renderedSubCriteria, fragmentCalculator));
    }

    public Optional<RenderedCriterion> render(List<AndOrCriteriaGroup> subCriteria, Function<FragmentCollector, String> fragmentCalculator) {
        List<RenderedCriterion> renderedSubCriteria = this.renderSubCriteria(subCriteria);
        return this.calculateRenderedCriterion(renderedSubCriteria, fragmentCalculator);
    }

    private <T> Optional<FragmentAndParameters> renderColumnAndCondition(ColumnAndConditionCriterion<T> criterion) {
        if (criterion.condition().shouldRender(this.renderingContext)) {
            return Optional.of(this.renderCondition(criterion));
        }
        criterion.condition().renderingSkipped();
        return Optional.empty();
    }

    private FragmentAndParameters renderExists(ExistsCriterion criterion) {
        ExistsPredicate existsPredicate = criterion.existsPredicate();
        SelectStatementProvider selectStatement = existsPredicate.selectModelBuilder().build().render(this.renderingContext);
        String fragment = existsPredicate.operator() + " (" + selectStatement.getSelectStatement() + ")";
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).build();
    }

    private List<RenderedCriterion> renderSubCriteria(List<AndOrCriteriaGroup> subCriteria) {
        return subCriteria.stream().map(this::renderAndOrCriteriaGroup).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RenderedCriterion> renderAndOrCriteriaGroup(AndOrCriteriaGroup criterion) {
        return criterion.initialCriterion().map(ic -> this.render((SqlCriterion)ic, criterion.subCriteria(), this::calculateFragment)).orElseGet(() -> this.render(criterion.subCriteria(), this::calculateFragment)).map(rc -> rc.withConnector(criterion.connector()));
    }

    private Optional<RenderedCriterion> calculateRenderedCriterion(FragmentAndParameters initialCriterion, List<RenderedCriterion> renderedSubCriteria, Function<FragmentCollector, String> fragmentCalculator) {
        return Optional.of(this.calculateRenderedCriterion(this.collectSqlFragments(initialCriterion, renderedSubCriteria), fragmentCalculator));
    }

    private RenderedCriterion calculateRenderedCriterion(FragmentCollector fragmentCollector, Function<FragmentCollector, String> fragmentCalculator) {
        FragmentAndParameters fragmentAndParameters = FragmentAndParameters.withFragment(fragmentCalculator.apply(fragmentCollector)).withParameters(fragmentCollector.parameters()).build();
        return new RenderedCriterion.Builder().withFragmentAndParameters(fragmentAndParameters).build();
    }

    private Optional<RenderedCriterion> calculateRenderedCriterion(List<RenderedCriterion> renderedSubCriteria, Function<FragmentCollector, String> fragmentCalculator) {
        return this.collectSqlFragments(renderedSubCriteria).map(fc -> this.calculateRenderedCriterion((FragmentCollector)fc, fragmentCalculator));
    }

    private <T> FragmentAndParameters renderCondition(ColumnAndConditionCriterion<T> criterion) {
        return new ColumnAndConditionRenderer.Builder<T>().withColumn(criterion.column()).withCondition(criterion.condition()).withRenderingContext(this.renderingContext).build().render();
    }

    private FragmentCollector collectSqlFragments(FragmentAndParameters initialCondition, List<RenderedCriterion> renderedSubCriteria) {
        return renderedSubCriteria.stream().map(RenderedCriterion::fragmentAndParametersWithConnector).collect(FragmentCollector.collect(initialCondition));
    }

    private Optional<FragmentCollector> collectSqlFragments(List<RenderedCriterion> renderedSubCriteria) {
        if (renderedSubCriteria.isEmpty()) {
            return Optional.empty();
        }
        FragmentAndParameters firstCondition = renderedSubCriteria.get(0).fragmentAndParameters();
        FragmentCollector fc = renderedSubCriteria.stream().skip(1L).map(RenderedCriterion::fragmentAndParametersWithConnector).collect(FragmentCollector.collect(firstCondition));
        return Optional.of(fc);
    }

    private String calculateFragment(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.collectFragments(Collectors.joining(" ", "(", ")"));
        }
        return collector.firstFragment().orElse("");
    }

    private String calculateNotFragment(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.collectFragments(Collectors.joining(" ", "not (", ")"));
        }
        return collector.firstFragment().map(s -> "not " + s).orElse("");
    }
}

