/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.render.DefaultConditionVisitor;

public class ColumnAndConditionRenderer<T> {
    private final BindableColumn<T> column;
    private final VisitableCondition<T> condition;
    private final RenderingContext renderingContext;

    private ColumnAndConditionRenderer(Builder<T> builder) {
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.condition = Objects.requireNonNull(((Builder)builder).condition);
        this.renderingContext = Objects.requireNonNull(((Builder)builder).renderingContext);
    }

    public FragmentAndParameters render() {
        FragmentAndParameters renderedLeftColumn = this.column.render(this.renderingContext);
        DefaultConditionVisitor<T> visitor = DefaultConditionVisitor.withColumn(this.column).withRenderingContext(this.renderingContext).build();
        FragmentAndParameters renderedCondition = (FragmentAndParameters)this.condition.accept(visitor);
        String finalFragment = this.condition.overrideRenderedLeftColumn(renderedLeftColumn.fragment()) + StringUtilities.spaceBefore(renderedCondition.fragment());
        return FragmentAndParameters.withFragment(finalFragment).withParameters(renderedLeftColumn.parameters()).withParameters(renderedCondition.parameters()).build();
    }

    public static class Builder<T> {
        private BindableColumn<T> column;
        private VisitableCondition<T> condition;
        private RenderingContext renderingContext;

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withCondition(VisitableCondition<T> condition) {
            this.condition = condition;
            return this;
        }

        public Builder<T> withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public ColumnAndConditionRenderer<T> build() {
            return new ColumnAndConditionRenderer(this);
        }
    }
}

