/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.Collection;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.util.Messages;

public class Validator {
    private Validator() {
    }

    public static void assertNotEmpty(Collection<?> collection, String messageNumber) {
        Validator.assertFalse(collection.isEmpty(), messageNumber);
    }

    public static void assertFalse(boolean condition, String messageNumber) {
        Validator.internalAssertFalse(condition, Messages.getString(messageNumber));
    }

    public static void assertFalse(boolean condition, String messageNumber, String p1) {
        Validator.internalAssertFalse(condition, Messages.getString(messageNumber, p1));
    }

    public static void assertTrue(boolean condition, String messageNumber) {
        Validator.assertFalse(!condition, messageNumber);
    }

    public static void assertTrue(boolean condition, String messageNumber, String p1) {
        Validator.assertFalse(!condition, messageNumber, p1);
    }

    private static void internalAssertFalse(boolean condition, String message) {
        if (condition) {
            throw new InvalidSqlException(message);
        }
    }
}

