/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.common.CommonBuilder;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.update.render.UpdateRenderer;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Validator;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class UpdateModel {
    private final SqlTable table;
    private final String tableAlias;
    private final EmbeddedWhereModel whereModel;
    private final List<AbstractColumnMapping> columnMappings;
    private final Long limit;
    private final OrderByModel orderByModel;
    private final StatementConfiguration statementConfiguration;

    private UpdateModel(Builder builder) {
        this.table = Objects.requireNonNull(builder.table());
        this.whereModel = builder.whereModel();
        this.columnMappings = Objects.requireNonNull(builder.columnMappings);
        this.tableAlias = builder.tableAlias();
        this.limit = builder.limit();
        this.orderByModel = builder.orderByModel();
        Validator.assertNotEmpty(this.columnMappings, "ERROR.17");
        this.statementConfiguration = Objects.requireNonNull(builder.statementConfiguration());
    }

    public SqlTable table() {
        return this.table;
    }

    public Optional<String> tableAlias() {
        return Optional.ofNullable(this.tableAlias);
    }

    public Optional<EmbeddedWhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public Stream<AbstractColumnMapping> columnMappings() {
        return this.columnMappings.stream();
    }

    public Optional<Long> limit() {
        return Optional.ofNullable(this.limit);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    @NotNull
    public UpdateStatementProvider render(RenderingStrategy renderingStrategy) {
        return UpdateRenderer.withUpdateModel(this).withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build().render();
    }

    public static Builder withTable(SqlTable table) {
        return (Builder)new Builder().withTable(table);
    }

    public static class Builder
    extends CommonBuilder<Builder> {
        private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

        public Builder withColumnMappings(List<? extends AbstractColumnMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public UpdateModel build() {
            return new UpdateModel(this);
        }
    }
}

