/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.InternalError;
import org.mybatis.dynamic.sql.util.Messages;

public class FetchFirstPagingModelRenderer {
    private final RenderingContext renderingContext;
    private final PagingModel pagingModel;

    public FetchFirstPagingModelRenderer(RenderingContext renderingContext, PagingModel pagingModel) {
        this.renderingContext = renderingContext;
        this.pagingModel = pagingModel;
    }

    public FragmentAndParameters render() {
        return this.pagingModel.offset().map(this::renderWithOffset).orElseGet(this::renderFetchFirstRowsOnly);
    }

    private FragmentAndParameters renderWithOffset(Long offset) {
        return this.pagingModel.fetchFirstRows().map(ffr -> this.renderOffsetAndFetchFirstRows(offset, (Long)ffr)).orElseGet(() -> this.renderOffsetOnly(offset));
    }

    private FragmentAndParameters renderFetchFirstRowsOnly() {
        return this.pagingModel.fetchFirstRows().map(this::renderFetchFirstRowsOnly).orElseThrow(() -> new InvalidSqlException(Messages.getInternalErrorString(InternalError.INTERNAL_ERROR_13)));
    }

    private FragmentAndParameters renderFetchFirstRowsOnly(Long fetchFirstRows) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("fetch first " + parameterInfo.renderedPlaceHolder() + " rows only").withParameter(parameterInfo.parameterMapKey(), fetchFirstRows).build();
    }

    private FragmentAndParameters renderOffsetOnly(Long offset) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("offset " + parameterInfo.renderedPlaceHolder() + " rows").withParameter(parameterInfo.parameterMapKey(), offset).build();
    }

    private FragmentAndParameters renderOffsetAndFetchFirstRows(Long offset, Long fetchFirstRows) {
        RenderedParameterInfo parameterInfo1 = this.renderingContext.calculateParameterInfo();
        RenderedParameterInfo parameterInfo2 = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("offset " + parameterInfo1.renderedPlaceHolder() + " rows fetch first " + parameterInfo2.renderedPlaceHolder() + " rows only").withParameter(parameterInfo1.parameterMapKey(), offset).withParameter(parameterInfo2.parameterMapKey(), fetchFirstRows).build();
    }
}

