/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.HavingModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.util.Validator;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class QueryExpressionModel {
    private final String connector;
    private final boolean isDistinct;
    private final List<BasicColumn> selectList;
    private final TableExpression table;
    private final JoinModel joinModel;
    private final Map<SqlTable, String> tableAliases;
    private final EmbeddedWhereModel whereModel;
    private final GroupByModel groupByModel;
    private final HavingModel havingModel;

    private QueryExpressionModel(Builder builder) {
        this.connector = builder.connector;
        this.isDistinct = builder.isDistinct;
        this.selectList = Objects.requireNonNull(builder.selectList);
        this.table = Objects.requireNonNull(builder.table);
        this.joinModel = builder.joinModel;
        this.tableAliases = builder.tableAliases;
        this.whereModel = builder.whereModel;
        this.groupByModel = builder.groupByModel;
        this.havingModel = builder.havingModel;
        Validator.assertNotEmpty(this.selectList, "ERROR.13");
    }

    public Optional<String> connector() {
        return Optional.ofNullable(this.connector);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public Stream<BasicColumn> columns() {
        return this.selectList.stream();
    }

    public TableExpression table() {
        return this.table;
    }

    public Map<SqlTable, String> tableAliases() {
        return this.tableAliases;
    }

    public Optional<EmbeddedWhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public Optional<JoinModel> joinModel() {
        return Optional.ofNullable(this.joinModel);
    }

    public Optional<GroupByModel> groupByModel() {
        return Optional.ofNullable(this.groupByModel);
    }

    public Optional<HavingModel> havingModel() {
        return Optional.ofNullable(this.havingModel);
    }

    public static Builder withSelectList(List<? extends BasicColumn> columnList) {
        return new Builder().withSelectList(columnList);
    }

    public static class Builder {
        private String connector;
        private boolean isDistinct;
        private final List<BasicColumn> selectList = new ArrayList<BasicColumn>();
        private TableExpression table;
        private final Map<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
        private EmbeddedWhereModel whereModel;
        private JoinModel joinModel;
        private GroupByModel groupByModel;
        private HavingModel havingModel;

        public Builder withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder withTable(TableExpression table) {
            this.table = table;
            return this;
        }

        public Builder isDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
            return this;
        }

        public Builder withSelectColumn(BasicColumn selectColumn) {
            this.selectList.add(selectColumn);
            return this;
        }

        public Builder withSelectList(List<? extends BasicColumn> selectList) {
            this.selectList.addAll(selectList);
            return this;
        }

        public Builder withTableAliases(Map<SqlTable, String> tableAliases) {
            this.tableAliases.putAll(tableAliases);
            return this;
        }

        public Builder withWhereModel(EmbeddedWhereModel whereModel) {
            this.whereModel = whereModel;
            return this;
        }

        public Builder withJoinModel(JoinModel joinModel) {
            this.joinModel = joinModel;
            return this;
        }

        public Builder withGroupByModel(GroupByModel groupByModel) {
            this.groupByModel = groupByModel;
            return this;
        }

        public Builder withHavingModel(HavingModel havingModel) {
            this.havingModel = havingModel;
            return this;
        }

        public QueryExpressionModel build() {
            return new QueryExpressionModel(this);
        }
    }
}

