/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.exception.DuplicateTableAliasException;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.SubQuery;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.join.JoinType;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.AbstractWhereFinisher;
import org.mybatis.dynamic.sql.where.AbstractWhereStarter;

public abstract class AbstractQueryExpressionDSL<W extends AbstractWhereFinisher<?>, T extends AbstractQueryExpressionDSL<W, T>>
extends AbstractWhereStarter<W, T> {
    private final List<JoinSpecification.Builder> joinSpecificationBuilders = new ArrayList<JoinSpecification.Builder>();
    private final Map<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
    private final TableExpression table;

    protected AbstractQueryExpressionDSL(TableExpression table) {
        this.table = Objects.requireNonNull(table);
    }

    public TableExpression table() {
        return this.table;
    }

    public T join(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.INNER, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T join(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.join(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T join(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.INNER, andJoinCriteria);
        return this.getThis();
    }

    public T join(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.join(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T join(Buildable<SelectModel> subQuery, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(AbstractQueryExpressionDSL.buildSubQuery(subQuery, tableAlias), onJoinCriterion, JoinType.INNER, andJoinCriteria);
        return this.getThis();
    }

    public T leftJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.LEFT, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T leftJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.leftJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T leftJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.LEFT, andJoinCriteria);
        return this.getThis();
    }

    public T leftJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.leftJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T leftJoin(Buildable<SelectModel> subQuery, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(AbstractQueryExpressionDSL.buildSubQuery(subQuery, tableAlias), onJoinCriterion, JoinType.LEFT, andJoinCriteria);
        return this.getThis();
    }

    public T rightJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.RIGHT, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T rightJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.rightJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T rightJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.RIGHT, andJoinCriteria);
        return this.getThis();
    }

    public T rightJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.rightJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T rightJoin(Buildable<SelectModel> subQuery, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(AbstractQueryExpressionDSL.buildSubQuery(subQuery, tableAlias), onJoinCriterion, JoinType.RIGHT, andJoinCriteria);
        return this.getThis();
    }

    public T fullJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.FULL, Arrays.asList(andJoinCriteria));
        return this.getThis();
    }

    public T fullJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, JoinCriterion<?> ... andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.fullJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T fullJoin(SqlTable joinTable, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(joinTable, onJoinCriterion, JoinType.FULL, andJoinCriteria);
        return this.getThis();
    }

    public T fullJoin(SqlTable joinTable, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addTableAlias(joinTable, tableAlias);
        return this.fullJoin(joinTable, onJoinCriterion, andJoinCriteria);
    }

    public T fullJoin(Buildable<SelectModel> subQuery, String tableAlias, JoinCriterion<?> onJoinCriterion, List<JoinCriterion<?>> andJoinCriteria) {
        this.addJoinSpecificationBuilder(AbstractQueryExpressionDSL.buildSubQuery(subQuery, tableAlias), onJoinCriterion, JoinType.FULL, andJoinCriteria);
        return this.getThis();
    }

    private void addJoinSpecificationBuilder(TableExpression joinTable, JoinCriterion<?> onJoinCriterion, JoinType joinType, List<JoinCriterion<?>> andJoinCriteria) {
        this.joinSpecificationBuilders.add(new JoinSpecification.Builder().withJoinTable(joinTable).withJoinType(joinType).withJoinCriterion(onJoinCriterion).withJoinCriteria(andJoinCriteria));
    }

    protected void addJoinSpecificationBuilder(JoinSpecification.Builder builder) {
        this.joinSpecificationBuilders.add(builder);
    }

    protected Optional<JoinModel> buildJoinModel() {
        if (this.joinSpecificationBuilders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(JoinModel.of(this.joinSpecificationBuilders.stream().map(JoinSpecification.Builder::build).collect(Collectors.toList())));
    }

    protected void addTableAlias(SqlTable table, String tableAlias) {
        if (this.tableAliases.containsKey(table)) {
            throw new DuplicateTableAliasException(table, tableAlias, this.tableAliases.get(table));
        }
        this.tableAliases.put(table, tableAlias);
    }

    protected Map<SqlTable, String> tableAliases() {
        return Collections.unmodifiableMap(this.tableAliases);
    }

    protected static SubQuery buildSubQuery(Buildable<SelectModel> selectModel) {
        return new SubQuery.Builder().withSelectModel(selectModel.build()).build();
    }

    protected static SubQuery buildSubQuery(Buildable<SelectModel> selectModel, String alias) {
        return new SubQuery.Builder().withSelectModel(selectModel.build()).withAlias(alias).build();
    }

    protected abstract T getThis();
}

