/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.render;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.render.TableAliasCalculatorWithParent;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class RenderingContext {
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;
    private final TableAliasCalculator tableAliasCalculator;
    private final String configuredParameterName;
    private final String calculatedParameterName;
    private final StatementConfiguration statementConfiguration;

    private RenderingContext(Builder builder) {
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.configuredParameterName = builder.parameterName;
        this.tableAliasCalculator = Objects.requireNonNull(builder.tableAliasCalculator);
        this.statementConfiguration = Objects.requireNonNull(builder.statementConfiguration);
        this.sequence = builder.sequence == null ? new AtomicInteger(1) : builder.sequence;
        this.calculatedParameterName = builder.parameterName == null ? "parameters" : builder.parameterName + "." + "parameters";
    }

    public TableAliasCalculator tableAliasCalculator() {
        return this.tableAliasCalculator;
    }

    private String nextMapKey() {
        return this.renderingStrategy.formatParameterMapKey(this.sequence);
    }

    private String renderedPlaceHolder(String mapKey) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder(this.calculatedParameterName, mapKey);
    }

    private <T> String renderedPlaceHolder(String mapKey, BindableColumn<T> column) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getFormattedJdbcPlaceholder(column, this.calculatedParameterName, mapKey);
    }

    public RenderedParameterInfo calculateParameterInfo() {
        String mapKey = this.nextMapKey();
        return new RenderedParameterInfo(mapKey, this.renderedPlaceHolder(mapKey));
    }

    public <T> RenderedParameterInfo calculateParameterInfo(BindableColumn<T> column) {
        String mapKey = this.nextMapKey();
        return new RenderedParameterInfo(mapKey, this.renderedPlaceHolder(mapKey, column));
    }

    public <T> String aliasedColumnName(SqlColumn<T> column) {
        return this.tableAliasCalculator.aliasForColumn(column.table()).map(alias -> this.aliasedColumnName(column, (String)alias)).orElseGet(column::name);
    }

    public <T> String aliasedColumnName(SqlColumn<T> column, String explicitAlias) {
        return explicitAlias + "." + column.name();
    }

    public String aliasedTableName(SqlTable table) {
        return this.tableAliasCalculator.aliasForTable(table).map(a -> table.tableNameAtRuntime() + StringUtilities.spaceBefore(a)).orElseGet(table::tableNameAtRuntime);
    }

    public boolean isNonRenderingClauseAllowed() {
        return this.statementConfiguration.isNonRenderingWhereClauseAllowed();
    }

    public RenderingContext withChildTableAliasCalculator(TableAliasCalculator childTableAliasCalculator) {
        TableAliasCalculatorWithParent tac = new TableAliasCalculatorWithParent.Builder().withParent(this.tableAliasCalculator).withChild(childTableAliasCalculator).build();
        return new Builder().withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).withParameterName(this.configuredParameterName).withTableAliasCalculator(tac).withStatementConfiguration(this.statementConfiguration).build();
    }

    public static Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
        return new Builder().withRenderingStrategy(renderingStrategy);
    }

    public static class Builder {
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;
        private TableAliasCalculator tableAliasCalculator = TableAliasCalculator.empty();
        private String parameterName;
        private StatementConfiguration statementConfiguration;

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public RenderingContext build() {
            return new RenderingContext(this);
        }
    }
}

