/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueAndParameters;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.GeneralInsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;

public class GeneralInsertValuePhraseVisitor
extends GeneralInsertMappingVisitor<Optional<FieldAndValueAndParameters>> {
    private final RenderingContext renderingContext;

    public GeneralInsertValuePhraseVisitor(RenderingContext renderingContext) {
        this.renderingContext = Objects.requireNonNull(renderingContext);
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(NullMapping mapping) {
        return this.buildNullFragment(mapping);
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(ConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(mapping.constant()).buildOptional();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(StringConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(StringUtilities.formatConstantForSQL(mapping.constant())).buildOptional();
    }

    @Override
    public <T> Optional<FieldAndValueAndParameters> visit(ValueMapping<T> mapping) {
        return this.buildValueFragment(mapping, mapping.value());
    }

    @Override
    public <T> Optional<FieldAndValueAndParameters> visit(ValueOrNullMapping<T> mapping) {
        return mapping.value().map(v -> this.buildValueFragment(mapping, v)).orElseGet(() -> this.buildNullFragment(mapping));
    }

    @Override
    public <T> Optional<FieldAndValueAndParameters> visit(ValueWhenPresentMapping<T> mapping) {
        return mapping.value().flatMap(v -> this.buildValueFragment(mapping, v));
    }

    private Optional<FieldAndValueAndParameters> buildValueFragment(AbstractColumnMapping mapping, Object value) {
        return this.buildFragment(mapping, value);
    }

    private Optional<FieldAndValueAndParameters> buildNullFragment(AbstractColumnMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase("null").buildOptional();
    }

    private Optional<FieldAndValueAndParameters> buildFragment(AbstractColumnMapping mapping, Object value) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo(mapping.column());
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(parameterInfo.renderedPlaceHolder()).withParameter(parameterInfo.parameterMapKey(), value).buildOptional();
    }
}

