/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.delete.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DefaultDeleteStatementProvider;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class DeleteRenderer {
    private final DeleteModel deleteModel;
    private final RenderingContext renderingContext;

    private DeleteRenderer(Builder builder) {
        this.deleteModel = Objects.requireNonNull(builder.deleteModel);
        TableAliasCalculator tableAliasCalculator = builder.deleteModel.tableAlias().map(a -> ExplicitTableAliasCalculator.of(this.deleteModel.table(), a)).orElseGet(TableAliasCalculator::empty);
        this.renderingContext = RenderingContext.withRenderingStrategy(Objects.requireNonNull(builder.renderingStrategy)).withTableAliasCalculator(tableAliasCalculator).withStatementConfiguration(builder.statementConfiguration).build();
    }

    public DeleteStatementProvider render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateDeleteStatementStart());
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateOrderByClause().ifPresent(fragmentCollector::add);
        this.calculateLimitClause().ifPresent(fragmentCollector::add);
        return this.toDeleteStatementProvider(fragmentCollector);
    }

    private DeleteStatementProvider toDeleteStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultDeleteStatementProvider.withDeleteStatement(fragmentCollector.collectFragments(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters calculateDeleteStatementStart() {
        String aliasedTableName = this.renderingContext.aliasedTableName(this.deleteModel.table());
        return FragmentAndParameters.fromFragment("delete from " + aliasedTableName);
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.deleteModel.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(EmbeddedWhereModel whereModel) {
        return whereModel.render(this.renderingContext);
    }

    private Optional<FragmentAndParameters> calculateLimitClause() {
        return this.deleteModel.limit().map(this::renderLimitClause);
    }

    private FragmentAndParameters renderLimitClause(Long limit) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("limit " + parameterInfo.renderedPlaceHolder()).withParameter(parameterInfo.parameterMapKey(), limit).build();
    }

    private Optional<FragmentAndParameters> calculateOrderByClause() {
        return this.deleteModel.orderByModel().map(this::renderOrderByClause);
    }

    private FragmentAndParameters renderOrderByClause(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    public static Builder withDeleteModel(DeleteModel deleteModel) {
        return new Builder().withDeleteModel(deleteModel);
    }

    public static class Builder {
        private DeleteModel deleteModel;
        private RenderingStrategy renderingStrategy;
        private StatementConfiguration statementConfiguration;

        public Builder withDeleteModel(DeleteModel deleteModel) {
            this.deleteModel = deleteModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public DeleteRenderer build() {
            return new DeleteRenderer(this);
        }
    }
}

