/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.delete;

import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.common.CommonBuilder;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.delete.render.DeleteRenderer;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class DeleteModel {
    private final SqlTable table;
    private final String tableAlias;
    private final EmbeddedWhereModel whereModel;
    private final Long limit;
    private final OrderByModel orderByModel;
    private final StatementConfiguration statementConfiguration;

    private DeleteModel(Builder builder) {
        this.table = Objects.requireNonNull(builder.table());
        this.whereModel = builder.whereModel();
        this.tableAlias = builder.tableAlias();
        this.limit = builder.limit();
        this.orderByModel = builder.orderByModel();
        this.statementConfiguration = Objects.requireNonNull(builder.statementConfiguration());
    }

    public SqlTable table() {
        return this.table;
    }

    public Optional<String> tableAlias() {
        return Optional.ofNullable(this.tableAlias);
    }

    public Optional<EmbeddedWhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public Optional<Long> limit() {
        return Optional.ofNullable(this.limit);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    @NotNull
    public DeleteStatementProvider render(RenderingStrategy renderingStrategy) {
        return DeleteRenderer.withDeleteModel(this).withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build().render();
    }

    public static Builder withTable(SqlTable table) {
        return (Builder)new Builder().withTable(table);
    }

    public static class Builder
    extends CommonBuilder<Builder> {
        @Override
        protected Builder getThis() {
            return this;
        }

        public DeleteModel build() {
            return new DeleteModel(this);
        }
    }
}

