/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH265DecPicBufMgr;
import org.lwjgl.vulkan.video.StdVideoH265HrdParameters;
import org.lwjgl.vulkan.video.StdVideoH265ProfileTierLevel;
import org.lwjgl.vulkan.video.StdVideoH265VpsFlags;

public class StdVideoH265VideoParameterSet
extends Struct<StdVideoH265VideoParameterSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int VPS_VIDEO_PARAMETER_SET_ID;
    public static final int VPS_MAX_SUB_LAYERS_MINUS1;
    public static final int RESERVED1;
    public static final int RESERVED2;
    public static final int VPS_NUM_UNITS_IN_TICK;
    public static final int VPS_TIME_SCALE;
    public static final int VPS_NUM_TICKS_POC_DIFF_ONE_MINUS1;
    public static final int RESERVED3;
    public static final int PDECPICBUFMGR;
    public static final int PHRDPARAMETERS;
    public static final int PPROFILETIERLEVEL;

    protected StdVideoH265VideoParameterSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoH265VideoParameterSet create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH265VideoParameterSet(address, container);
    }

    public StdVideoH265VideoParameterSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoH265VideoParameterSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH265VpsFlags flags() {
        return StdVideoH265VideoParameterSet.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte vps_video_parameter_set_id() {
        return StdVideoH265VideoParameterSet.nvps_video_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte vps_max_sub_layers_minus1() {
        return StdVideoH265VideoParameterSet.nvps_max_sub_layers_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int vps_num_units_in_tick() {
        return StdVideoH265VideoParameterSet.nvps_num_units_in_tick(this.address());
    }

    @NativeType(value="uint32_t")
    public int vps_time_scale() {
        return StdVideoH265VideoParameterSet.nvps_time_scale(this.address());
    }

    @NativeType(value="uint32_t")
    public int vps_num_ticks_poc_diff_one_minus1() {
        return StdVideoH265VideoParameterSet.nvps_num_ticks_poc_diff_one_minus1(this.address());
    }

    @NativeType(value="StdVideoH265DecPicBufMgr const *")
    public StdVideoH265DecPicBufMgr pDecPicBufMgr() {
        return StdVideoH265VideoParameterSet.npDecPicBufMgr(this.address());
    }

    @NativeType(value="StdVideoH265HrdParameters const *")
    public StdVideoH265HrdParameters pHrdParameters() {
        return StdVideoH265VideoParameterSet.npHrdParameters(this.address());
    }

    @NativeType(value="StdVideoH265ProfileTierLevel const *")
    public StdVideoH265ProfileTierLevel pProfileTierLevel() {
        return StdVideoH265VideoParameterSet.npProfileTierLevel(this.address());
    }

    public StdVideoH265VideoParameterSet flags(StdVideoH265VpsFlags value) {
        StdVideoH265VideoParameterSet.nflags(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet flags(Consumer<StdVideoH265VpsFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH265VideoParameterSet vps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265VideoParameterSet.nvps_video_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet vps_max_sub_layers_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265VideoParameterSet.nvps_max_sub_layers_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet vps_num_units_in_tick(@NativeType(value="uint32_t") int value) {
        StdVideoH265VideoParameterSet.nvps_num_units_in_tick(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet vps_time_scale(@NativeType(value="uint32_t") int value) {
        StdVideoH265VideoParameterSet.nvps_time_scale(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet vps_num_ticks_poc_diff_one_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH265VideoParameterSet.nvps_num_ticks_poc_diff_one_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet pDecPicBufMgr(@NativeType(value="StdVideoH265DecPicBufMgr const *") StdVideoH265DecPicBufMgr value) {
        StdVideoH265VideoParameterSet.npDecPicBufMgr(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet pHrdParameters(@NativeType(value="StdVideoH265HrdParameters const *") StdVideoH265HrdParameters value) {
        StdVideoH265VideoParameterSet.npHrdParameters(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet pProfileTierLevel(@NativeType(value="StdVideoH265ProfileTierLevel const *") StdVideoH265ProfileTierLevel value) {
        StdVideoH265VideoParameterSet.npProfileTierLevel(this.address(), value);
        return this;
    }

    public StdVideoH265VideoParameterSet set(StdVideoH265VpsFlags flags, byte vps_video_parameter_set_id, byte vps_max_sub_layers_minus1, int vps_num_units_in_tick, int vps_time_scale, int vps_num_ticks_poc_diff_one_minus1, StdVideoH265DecPicBufMgr pDecPicBufMgr, StdVideoH265HrdParameters pHrdParameters, StdVideoH265ProfileTierLevel pProfileTierLevel) {
        this.flags(flags);
        this.vps_video_parameter_set_id(vps_video_parameter_set_id);
        this.vps_max_sub_layers_minus1(vps_max_sub_layers_minus1);
        this.vps_num_units_in_tick(vps_num_units_in_tick);
        this.vps_time_scale(vps_time_scale);
        this.vps_num_ticks_poc_diff_one_minus1(vps_num_ticks_poc_diff_one_minus1);
        this.pDecPicBufMgr(pDecPicBufMgr);
        this.pHrdParameters(pHrdParameters);
        this.pProfileTierLevel(pProfileTierLevel);
        return this;
    }

    public StdVideoH265VideoParameterSet set(StdVideoH265VideoParameterSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoH265VideoParameterSet malloc() {
        return new StdVideoH265VideoParameterSet(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoH265VideoParameterSet calloc() {
        return new StdVideoH265VideoParameterSet(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoH265VideoParameterSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoH265VideoParameterSet(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoH265VideoParameterSet create(long address) {
        return new StdVideoH265VideoParameterSet(address, null);
    }

    @Nullable
    public static StdVideoH265VideoParameterSet createSafe(long address) {
        return address == 0L ? null : new StdVideoH265VideoParameterSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoH265VideoParameterSet.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265VideoParameterSet.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH265VideoParameterSet malloc(MemoryStack stack) {
        return new StdVideoH265VideoParameterSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH265VideoParameterSet calloc(MemoryStack stack) {
        return new StdVideoH265VideoParameterSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH265VpsFlags nflags(long struct) {
        return StdVideoH265VpsFlags.create(struct + (long)FLAGS);
    }

    public static byte nvps_video_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)VPS_VIDEO_PARAMETER_SET_ID);
    }

    public static byte nvps_max_sub_layers_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)VPS_MAX_SUB_LAYERS_MINUS1);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static byte nreserved2(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED2);
    }

    public static int nvps_num_units_in_tick(long struct) {
        return UNSAFE.getInt(null, struct + (long)VPS_NUM_UNITS_IN_TICK);
    }

    public static int nvps_time_scale(long struct) {
        return UNSAFE.getInt(null, struct + (long)VPS_TIME_SCALE);
    }

    public static int nvps_num_ticks_poc_diff_one_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)VPS_NUM_TICKS_POC_DIFF_ONE_MINUS1);
    }

    public static int nreserved3(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED3);
    }

    public static StdVideoH265DecPicBufMgr npDecPicBufMgr(long struct) {
        return StdVideoH265DecPicBufMgr.create(MemoryUtil.memGetAddress((long)(struct + (long)PDECPICBUFMGR)));
    }

    public static StdVideoH265HrdParameters npHrdParameters(long struct) {
        return StdVideoH265HrdParameters.create(MemoryUtil.memGetAddress((long)(struct + (long)PHRDPARAMETERS)));
    }

    public static StdVideoH265ProfileTierLevel npProfileTierLevel(long struct) {
        return StdVideoH265ProfileTierLevel.create(MemoryUtil.memGetAddress((long)(struct + (long)PPROFILETIERLEVEL)));
    }

    public static void nflags(long struct, StdVideoH265VpsFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoH265VpsFlags.SIZEOF);
    }

    public static void nvps_video_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)VPS_VIDEO_PARAMETER_SET_ID, value);
    }

    public static void nvps_max_sub_layers_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)VPS_MAX_SUB_LAYERS_MINUS1, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void nreserved2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED2, value);
    }

    public static void nvps_num_units_in_tick(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VPS_NUM_UNITS_IN_TICK, value);
    }

    public static void nvps_time_scale(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VPS_TIME_SCALE, value);
    }

    public static void nvps_num_ticks_poc_diff_one_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VPS_NUM_TICKS_POC_DIFF_ONE_MINUS1, value);
    }

    public static void nreserved3(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED3, value);
    }

    public static void npDecPicBufMgr(long struct, StdVideoH265DecPicBufMgr value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDECPICBUFMGR), (long)value.address());
    }

    public static void npHrdParameters(long struct, StdVideoH265HrdParameters value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHRDPARAMETERS), (long)value.address());
    }

    public static void npProfileTierLevel(long struct, StdVideoH265ProfileTierLevel value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPROFILETIERLEVEL), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDECPICBUFMGR)));
        long pHrdParameters = MemoryUtil.memGetAddress((long)(struct + (long)PHRDPARAMETERS));
        Checks.check((long)pHrdParameters);
        StdVideoH265HrdParameters.validate(pHrdParameters);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPROFILETIERLEVEL)));
    }

    static {
        Struct.Layout layout = StdVideoH265VideoParameterSet.__struct((Struct.Member[])new Struct.Member[]{StdVideoH265VideoParameterSet.__member((int)StdVideoH265VpsFlags.SIZEOF, (int)StdVideoH265VpsFlags.ALIGNOF), StdVideoH265VideoParameterSet.__member((int)1), StdVideoH265VideoParameterSet.__member((int)1), StdVideoH265VideoParameterSet.__member((int)1), StdVideoH265VideoParameterSet.__member((int)1), StdVideoH265VideoParameterSet.__member((int)4), StdVideoH265VideoParameterSet.__member((int)4), StdVideoH265VideoParameterSet.__member((int)4), StdVideoH265VideoParameterSet.__member((int)4), StdVideoH265VideoParameterSet.__member((int)POINTER_SIZE), StdVideoH265VideoParameterSet.__member((int)POINTER_SIZE), StdVideoH265VideoParameterSet.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        VPS_VIDEO_PARAMETER_SET_ID = layout.offsetof(1);
        VPS_MAX_SUB_LAYERS_MINUS1 = layout.offsetof(2);
        RESERVED1 = layout.offsetof(3);
        RESERVED2 = layout.offsetof(4);
        VPS_NUM_UNITS_IN_TICK = layout.offsetof(5);
        VPS_TIME_SCALE = layout.offsetof(6);
        VPS_NUM_TICKS_POC_DIFF_ONE_MINUS1 = layout.offsetof(7);
        RESERVED3 = layout.offsetof(8);
        PDECPICBUFMGR = layout.offsetof(9);
        PHRDPARAMETERS = layout.offsetof(10);
        PPROFILETIERLEVEL = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265VideoParameterSet, Buffer>
    implements NativeResource {
        private static final StdVideoH265VideoParameterSet ELEMENT_FACTORY = StdVideoH265VideoParameterSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoH265VideoParameterSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH265VpsFlags flags() {
            return StdVideoH265VideoParameterSet.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte vps_video_parameter_set_id() {
            return StdVideoH265VideoParameterSet.nvps_video_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte vps_max_sub_layers_minus1() {
            return StdVideoH265VideoParameterSet.nvps_max_sub_layers_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int vps_num_units_in_tick() {
            return StdVideoH265VideoParameterSet.nvps_num_units_in_tick(this.address());
        }

        @NativeType(value="uint32_t")
        public int vps_time_scale() {
            return StdVideoH265VideoParameterSet.nvps_time_scale(this.address());
        }

        @NativeType(value="uint32_t")
        public int vps_num_ticks_poc_diff_one_minus1() {
            return StdVideoH265VideoParameterSet.nvps_num_ticks_poc_diff_one_minus1(this.address());
        }

        @NativeType(value="StdVideoH265DecPicBufMgr const *")
        public StdVideoH265DecPicBufMgr pDecPicBufMgr() {
            return StdVideoH265VideoParameterSet.npDecPicBufMgr(this.address());
        }

        @NativeType(value="StdVideoH265HrdParameters const *")
        public StdVideoH265HrdParameters pHrdParameters() {
            return StdVideoH265VideoParameterSet.npHrdParameters(this.address());
        }

        @NativeType(value="StdVideoH265ProfileTierLevel const *")
        public StdVideoH265ProfileTierLevel pProfileTierLevel() {
            return StdVideoH265VideoParameterSet.npProfileTierLevel(this.address());
        }

        public Buffer flags(StdVideoH265VpsFlags value) {
            StdVideoH265VideoParameterSet.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH265VpsFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer vps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265VideoParameterSet.nvps_video_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer vps_max_sub_layers_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265VideoParameterSet.nvps_max_sub_layers_minus1(this.address(), value);
            return this;
        }

        public Buffer vps_num_units_in_tick(@NativeType(value="uint32_t") int value) {
            StdVideoH265VideoParameterSet.nvps_num_units_in_tick(this.address(), value);
            return this;
        }

        public Buffer vps_time_scale(@NativeType(value="uint32_t") int value) {
            StdVideoH265VideoParameterSet.nvps_time_scale(this.address(), value);
            return this;
        }

        public Buffer vps_num_ticks_poc_diff_one_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH265VideoParameterSet.nvps_num_ticks_poc_diff_one_minus1(this.address(), value);
            return this;
        }

        public Buffer pDecPicBufMgr(@NativeType(value="StdVideoH265DecPicBufMgr const *") StdVideoH265DecPicBufMgr value) {
            StdVideoH265VideoParameterSet.npDecPicBufMgr(this.address(), value);
            return this;
        }

        public Buffer pHrdParameters(@NativeType(value="StdVideoH265HrdParameters const *") StdVideoH265HrdParameters value) {
            StdVideoH265VideoParameterSet.npHrdParameters(this.address(), value);
            return this;
        }

        public Buffer pProfileTierLevel(@NativeType(value="StdVideoH265ProfileTierLevel const *") StdVideoH265ProfileTierLevel value) {
            StdVideoH265VideoParameterSet.npProfileTierLevel(this.address(), value);
            return this;
        }
    }
}

