/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoH264HrdParameters
extends Struct<StdVideoH264HrdParameters>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPB_CNT_MINUS1;
    public static final int BIT_RATE_SCALE;
    public static final int CPB_SIZE_SCALE;
    public static final int RESERVED1;
    public static final int BIT_RATE_VALUE_MINUS1;
    public static final int CPB_SIZE_VALUE_MINUS1;
    public static final int CBR_FLAG;
    public static final int INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int DPB_OUTPUT_DELAY_LENGTH_MINUS1;
    public static final int TIME_OFFSET_LENGTH;

    protected StdVideoH264HrdParameters(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoH264HrdParameters create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH264HrdParameters(address, container);
    }

    public StdVideoH264HrdParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoH264HrdParameters.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte cpb_cnt_minus1() {
        return StdVideoH264HrdParameters.ncpb_cnt_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_rate_scale() {
        return StdVideoH264HrdParameters.nbit_rate_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_size_scale() {
        return StdVideoH264HrdParameters.ncpb_size_scale(this.address());
    }

    @NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
    public IntBuffer bit_rate_value_minus1() {
        return StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int bit_rate_value_minus1(int index) {
        return StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), index);
    }

    @NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
    public IntBuffer cpb_size_value_minus1() {
        return StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int cpb_size_value_minus1(int index) {
        return StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
    public ByteBuffer cbr_flag() {
        return StdVideoH264HrdParameters.ncbr_flag(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cbr_flag(int index) {
        return StdVideoH264HrdParameters.ncbr_flag(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int initial_cpb_removal_delay_length_minus1() {
        return StdVideoH264HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int cpb_removal_delay_length_minus1() {
        return StdVideoH264HrdParameters.ncpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int dpb_output_delay_length_minus1() {
        return StdVideoH264HrdParameters.ndpb_output_delay_length_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int time_offset_length() {
        return StdVideoH264HrdParameters.ntime_offset_length(this.address());
    }

    public StdVideoH264HrdParameters cpb_cnt_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH264HrdParameters.ncpb_cnt_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters bit_rate_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH264HrdParameters.nbit_rate_scale(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters cpb_size_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH264HrdParameters.ncpb_size_scale(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters bit_rate_value_minus1(@NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") IntBuffer value) {
        StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters bit_rate_value_minus1(int index, @NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH264HrdParameters cpb_size_value_minus1(@NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") IntBuffer value) {
        StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters cpb_size_value_minus1(int index, @NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH264HrdParameters cbr_flag(@NativeType(value="uint8_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") ByteBuffer value) {
        StdVideoH264HrdParameters.ncbr_flag(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters cbr_flag(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH264HrdParameters.ncbr_flag(this.address(), index, value);
        return this;
    }

    public StdVideoH264HrdParameters initial_cpb_removal_delay_length_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters cpb_removal_delay_length_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.ncpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters dpb_output_delay_length_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters time_offset_length(@NativeType(value="uint32_t") int value) {
        StdVideoH264HrdParameters.ntime_offset_length(this.address(), value);
        return this;
    }

    public StdVideoH264HrdParameters set(byte cpb_cnt_minus1, byte bit_rate_scale, byte cpb_size_scale, IntBuffer bit_rate_value_minus1, IntBuffer cpb_size_value_minus1, ByteBuffer cbr_flag, int initial_cpb_removal_delay_length_minus1, int cpb_removal_delay_length_minus1, int dpb_output_delay_length_minus1, int time_offset_length) {
        this.cpb_cnt_minus1(cpb_cnt_minus1);
        this.bit_rate_scale(bit_rate_scale);
        this.cpb_size_scale(cpb_size_scale);
        this.bit_rate_value_minus1(bit_rate_value_minus1);
        this.cpb_size_value_minus1(cpb_size_value_minus1);
        this.cbr_flag(cbr_flag);
        this.initial_cpb_removal_delay_length_minus1(initial_cpb_removal_delay_length_minus1);
        this.cpb_removal_delay_length_minus1(cpb_removal_delay_length_minus1);
        this.dpb_output_delay_length_minus1(dpb_output_delay_length_minus1);
        this.time_offset_length(time_offset_length);
        return this;
    }

    public StdVideoH264HrdParameters set(StdVideoH264HrdParameters src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoH264HrdParameters malloc() {
        return new StdVideoH264HrdParameters(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoH264HrdParameters calloc() {
        return new StdVideoH264HrdParameters(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoH264HrdParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoH264HrdParameters(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoH264HrdParameters create(long address) {
        return new StdVideoH264HrdParameters(address, null);
    }

    @Nullable
    public static StdVideoH264HrdParameters createSafe(long address) {
        return address == 0L ? null : new StdVideoH264HrdParameters(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoH264HrdParameters.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH264HrdParameters.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH264HrdParameters malloc(MemoryStack stack) {
        return new StdVideoH264HrdParameters(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH264HrdParameters calloc(MemoryStack stack) {
        return new StdVideoH264HrdParameters(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte ncpb_cnt_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)CPB_CNT_MINUS1);
    }

    public static byte nbit_rate_scale(long struct) {
        return UNSAFE.getByte(null, struct + (long)BIT_RATE_SCALE);
    }

    public static byte ncpb_size_scale(long struct) {
        return UNSAFE.getByte(null, struct + (long)CPB_SIZE_SCALE);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static IntBuffer nbit_rate_value_minus1(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)BIT_RATE_VALUE_MINUS1), (int)32);
    }

    public static int nbit_rate_value_minus1(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)BIT_RATE_VALUE_MINUS1 + Checks.check((int)index, (int)32) * 4L);
    }

    public static IntBuffer ncpb_size_value_minus1(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)CPB_SIZE_VALUE_MINUS1), (int)32);
    }

    public static int ncpb_size_value_minus1(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)CPB_SIZE_VALUE_MINUS1 + Checks.check((int)index, (int)32) * 4L);
    }

    public static ByteBuffer ncbr_flag(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)CBR_FLAG), (int)32);
    }

    public static byte ncbr_flag(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CBR_FLAG + Checks.check((int)index, (int)32) * 1L);
    }

    public static int ninitial_cpb_removal_delay_length_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1);
    }

    public static int ncpb_removal_delay_length_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)CPB_REMOVAL_DELAY_LENGTH_MINUS1);
    }

    public static int ndpb_output_delay_length_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1);
    }

    public static int ntime_offset_length(long struct) {
        return UNSAFE.getInt(null, struct + (long)TIME_OFFSET_LENGTH);
    }

    public static void ncpb_cnt_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CPB_CNT_MINUS1, value);
    }

    public static void nbit_rate_scale(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)BIT_RATE_SCALE, value);
    }

    public static void ncpb_size_scale(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CPB_SIZE_SCALE, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void nbit_rate_value_minus1(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)BIT_RATE_VALUE_MINUS1), (long)(value.remaining() * 4));
    }

    public static void nbit_rate_value_minus1(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)BIT_RATE_VALUE_MINUS1 + Checks.check((int)index, (int)32) * 4L, value);
    }

    public static void ncpb_size_value_minus1(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)CPB_SIZE_VALUE_MINUS1), (long)(value.remaining() * 4));
    }

    public static void ncpb_size_value_minus1(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)CPB_SIZE_VALUE_MINUS1 + Checks.check((int)index, (int)32) * 4L, value);
    }

    public static void ncbr_flag(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)CBR_FLAG), (long)(value.remaining() * 1));
    }

    public static void ncbr_flag(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)CBR_FLAG + Checks.check((int)index, (int)32) * 1L, value);
    }

    public static void ninitial_cpb_removal_delay_length_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1, value);
    }

    public static void ncpb_removal_delay_length_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CPB_REMOVAL_DELAY_LENGTH_MINUS1, value);
    }

    public static void ndpb_output_delay_length_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1, value);
    }

    public static void ntime_offset_length(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TIME_OFFSET_LENGTH, value);
    }

    static {
        Struct.Layout layout = StdVideoH264HrdParameters.__struct((Struct.Member[])new Struct.Member[]{StdVideoH264HrdParameters.__member((int)1), StdVideoH264HrdParameters.__member((int)1), StdVideoH264HrdParameters.__member((int)1), StdVideoH264HrdParameters.__member((int)1), StdVideoH264HrdParameters.__array((int)4, (int)32), StdVideoH264HrdParameters.__array((int)4, (int)32), StdVideoH264HrdParameters.__array((int)1, (int)32), StdVideoH264HrdParameters.__member((int)4), StdVideoH264HrdParameters.__member((int)4), StdVideoH264HrdParameters.__member((int)4), StdVideoH264HrdParameters.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPB_CNT_MINUS1 = layout.offsetof(0);
        BIT_RATE_SCALE = layout.offsetof(1);
        CPB_SIZE_SCALE = layout.offsetof(2);
        RESERVED1 = layout.offsetof(3);
        BIT_RATE_VALUE_MINUS1 = layout.offsetof(4);
        CPB_SIZE_VALUE_MINUS1 = layout.offsetof(5);
        CBR_FLAG = layout.offsetof(6);
        INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(7);
        CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(8);
        DPB_OUTPUT_DELAY_LENGTH_MINUS1 = layout.offsetof(9);
        TIME_OFFSET_LENGTH = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH264HrdParameters, Buffer>
    implements NativeResource {
        private static final StdVideoH264HrdParameters ELEMENT_FACTORY = StdVideoH264HrdParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoH264HrdParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte cpb_cnt_minus1() {
            return StdVideoH264HrdParameters.ncpb_cnt_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_rate_scale() {
            return StdVideoH264HrdParameters.nbit_rate_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_size_scale() {
            return StdVideoH264HrdParameters.ncpb_size_scale(this.address());
        }

        @NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
        public IntBuffer bit_rate_value_minus1() {
            return StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int bit_rate_value_minus1(int index) {
            return StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), index);
        }

        @NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
        public IntBuffer cpb_size_value_minus1() {
            return StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int cpb_size_value_minus1(int index) {
            return StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]")
        public ByteBuffer cbr_flag() {
            return StdVideoH264HrdParameters.ncbr_flag(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cbr_flag(int index) {
            return StdVideoH264HrdParameters.ncbr_flag(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int initial_cpb_removal_delay_length_minus1() {
            return StdVideoH264HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int cpb_removal_delay_length_minus1() {
            return StdVideoH264HrdParameters.ncpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int dpb_output_delay_length_minus1() {
            return StdVideoH264HrdParameters.ndpb_output_delay_length_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int time_offset_length() {
            return StdVideoH264HrdParameters.ntime_offset_length(this.address());
        }

        public Buffer cpb_cnt_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH264HrdParameters.ncpb_cnt_minus1(this.address(), value);
            return this;
        }

        public Buffer bit_rate_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH264HrdParameters.nbit_rate_scale(this.address(), value);
            return this;
        }

        public Buffer cpb_size_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH264HrdParameters.ncpb_size_scale(this.address(), value);
            return this;
        }

        public Buffer bit_rate_value_minus1(@NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") IntBuffer value) {
            StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), value);
            return this;
        }

        public Buffer bit_rate_value_minus1(int index, @NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.nbit_rate_value_minus1(this.address(), index, value);
            return this;
        }

        public Buffer cpb_size_value_minus1(@NativeType(value="uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") IntBuffer value) {
            StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_size_value_minus1(int index, @NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.ncpb_size_value_minus1(this.address(), index, value);
            return this;
        }

        public Buffer cbr_flag(@NativeType(value="uint8_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]") ByteBuffer value) {
            StdVideoH264HrdParameters.ncbr_flag(this.address(), value);
            return this;
        }

        public Buffer cbr_flag(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH264HrdParameters.ncbr_flag(this.address(), index, value);
            return this;
        }

        public Buffer initial_cpb_removal_delay_length_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_removal_delay_length_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.ncpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer dpb_output_delay_length_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer time_offset_length(@NativeType(value="uint32_t") int value) {
            StdVideoH264HrdParameters.ntime_offset_length(this.address(), value);
            return this;
        }
    }
}

